/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.agentweb;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.gymchina.android.agentweb.Action;
import com.gymchina.android.agentweb.AgentWebUtils;
import com.gymchina.android.agentweb.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public final class ActionActivity
extends Activity {
    public static final String KEY_ACTION = "KEY_ACTION";
    public static final String KEY_URI = "KEY_URI";
    public static final String KEY_FROM_INTENTION = "KEY_FROM_INTENTION";
    public static final String KEY_FILE_CHOOSER_INTENT = "KEY_FILE_CHOOSER_INTENT";
    private static RationaleListener mRationaleListener;
    private static PermissionListener mPermissionListener;
    private static ChooserListener mChooserListener;
    private static final String TAG;
    private Action mAction;
    public static final int REQUEST_CODE = 596;
    private Uri mUri;

    public static void start(Activity activity, Action action) {
        Intent mIntent = new Intent((Context)activity, ActionActivity.class);
        mIntent.putExtra(KEY_ACTION, (Parcelable)action);
        activity.startActivity(mIntent);
    }

    public static void setChooserListener(ChooserListener chooserListener) {
        mChooserListener = chooserListener;
    }

    public static void setPermissionListener(PermissionListener permissionListener) {
        mPermissionListener = permissionListener;
    }

    private void cancelAction() {
        mChooserListener = null;
        mPermissionListener = null;
        mRationaleListener = null;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            LogUtils.i(TAG, "savedInstanceState:" + savedInstanceState);
            return;
        }
        Intent intent = this.getIntent();
        this.mAction = (Action)intent.getParcelableExtra(KEY_ACTION);
        if (this.mAction == null) {
            this.cancelAction();
            this.finish();
            return;
        }
        if (this.mAction.getAction() == 1) {
            this.permission(this.mAction);
        } else if (this.mAction.getAction() == 3) {
            this.realOpenCamera();
        } else {
            this.fetchFile(this.mAction);
        }
    }

    private void fetchFile(Action action) {
        if (mChooserListener == null) {
            this.finish();
        }
        this.realOpenFileChooser();
    }

    private void realOpenFileChooser() {
        block4: {
            try {
                if (mChooserListener == null) {
                    this.finish();
                    return;
                }
                Intent mIntent = (Intent)this.getIntent().getParcelableExtra(KEY_FILE_CHOOSER_INTENT);
                if (mIntent == null) {
                    this.cancelAction();
                    return;
                }
                this.startActivityForResult(mIntent, 596);
            }
            catch (Throwable throwable) {
                LogUtils.i(TAG, "\u627e\u4e0d\u5230\u6587\u4ef6\u9009\u62e9\u5668");
                this.chooserActionCallback(-1, null);
                if (!LogUtils.isDebug()) break block4;
                throwable.printStackTrace();
            }
        }
    }

    private void chooserActionCallback(int resultCode, Intent data) {
        if (mChooserListener != null) {
            mChooserListener.onChoiceResult(596, resultCode, data);
            mChooserListener = null;
        }
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 596) {
            this.chooserActionCallback(resultCode, this.mUri != null ? new Intent().putExtra(KEY_URI, (Parcelable)this.mUri) : data);
        }
    }

    private void permission(Action action) {
        ArrayList<String> permissions = action.getPermissions();
        if (AgentWebUtils.isEmptyCollection(permissions)) {
            mPermissionListener = null;
            mRationaleListener = null;
            this.finish();
            return;
        }
        if (mRationaleListener != null) {
            String permission;
            boolean rationale = false;
            Iterator iterator = permissions.iterator();
            while (iterator.hasNext() && !(rationale = this.shouldShowRequestPermissionRationale(permission = (String)iterator.next()))) {
            }
            mRationaleListener.onRationaleResult(rationale, new Bundle());
            mRationaleListener = null;
            this.finish();
            return;
        }
        if (mPermissionListener != null) {
            this.requestPermissions(permissions.toArray(new String[0]), 1);
        }
    }

    private void realOpenCamera() {
        block5: {
            try {
                File mFile;
                if (mChooserListener == null) {
                    this.finish();
                }
                if ((mFile = AgentWebUtils.createImageFile((Context)this)) == null) {
                    mChooserListener.onChoiceResult(596, 0, null);
                    mChooserListener = null;
                    this.finish();
                }
                Intent intent = AgentWebUtils.getIntentCaptureCompat((Context)this, mFile);
                this.mUri = (Uri)intent.getParcelableExtra("output");
                this.startActivityForResult(intent, 596);
            }
            catch (Throwable ignore) {
                LogUtils.e(TAG, "\u627e\u4e0d\u5230\u7cfb\u7edf\u76f8\u673a");
                if (mChooserListener != null) {
                    mChooserListener.onChoiceResult(596, 0, null);
                }
                mChooserListener = null;
                if (!LogUtils.isDebug()) break block5;
                ignore.printStackTrace();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (mPermissionListener != null) {
            Bundle mBundle = new Bundle();
            mBundle.putInt(KEY_FROM_INTENTION, this.mAction.getFromIntention());
            mPermissionListener.onRequestPermissionsResult(permissions, grantResults, mBundle);
        }
        mPermissionListener = null;
        this.finish();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    static {
        TAG = ActionActivity.class.getSimpleName();
    }

    public static interface ChooserListener {
        public void onChoiceResult(int var1, int var2, Intent var3);
    }

    public static interface PermissionListener {
        public void onRequestPermissionsResult(@NonNull String[] var1, @NonNull int[] var2, Bundle var3);
    }

    public static interface RationaleListener {
        public void onRationaleResult(boolean var1, Bundle var2);
    }
}

