/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.statistics.entry;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Keep
public class Event
implements Serializable,
Parcelable {
    private static final long serialVersionUID = 720347762533646859L;
    private Long id;
    private String UUID;
    private String type;
    private long timestamp;
    private Map<String, String> changeParams;
    private Map<String, String> data;
    private boolean pushFailed = false;
    private boolean locked = false;
    public static final Parcelable.Creator<Event> CREATOR = new Parcelable.Creator<Event>(){

        public Event createFromParcel(Parcel source) {
            return new Event(source);
        }

        public Event[] newArray(int size) {
            return new Event[size];
        }
    };

    @Nullable
    public String getDataEl(String key) {
        return this.data != null ? this.data.get(key) : null;
    }

    public void putDataEl(String key, String value) {
        if (this.data == null) {
            this.data = new HashMap<String, String>();
        }
        this.data.put(key, value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUUID() {
        return this.UUID;
    }

    public void setUUID(String UUID) {
        this.UUID = UUID;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Map<String, String> getChangeParams() {
        return this.changeParams;
    }

    public void setChangeParams(Map<String, String> changeParams) {
        this.changeParams = changeParams;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public boolean isPushFailed() {
        return this.pushFailed;
    }

    public boolean getPushFailed() {
        return this.pushFailed;
    }

    public void setPushFailed(boolean pushFailed) {
        this.pushFailed = pushFailed;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public String toString() {
        return "Event{id=" + this.id + ", UUID='" + this.UUID + '\'' + ", type='" + this.type + '\'' + ", timestamp=" + this.timestamp + ", changeParams=" + this.changeParams + ", data=" + this.data + ", pushFailed=" + this.pushFailed + ", locked=" + this.locked + '}';
    }

    public boolean getLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        if (Build.VERSION.SDK_INT >= 19) {
            return Objects.equals(this.UUID, event.UUID);
        }
        return this.UUID != null ? this.UUID.equals(event.UUID) : event.UUID == null;
    }

    public int hashCode() {
        if (Build.VERSION.SDK_INT >= 19) {
            return Objects.hash(this.UUID);
        }
        return this.UUID != null ? this.UUID.hashCode() : 0;
    }

    public Event() {
    }

    public Event(Long id, String UUID, String type, long timestamp, Map<String, String> changeParams, Map<String, String> data, boolean pushFailed, boolean locked) {
        this.id = id;
        this.UUID = UUID;
        this.type = type;
        this.timestamp = timestamp;
        this.changeParams = changeParams;
        this.data = data;
        this.pushFailed = pushFailed;
        this.locked = locked;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.id);
        dest.writeString(this.UUID);
        dest.writeString(this.type);
        dest.writeLong(this.timestamp);
        dest.writeInt(this.changeParams.size());
        for (Map.Entry<String, String> entry : this.changeParams.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
        dest.writeInt(this.data.size());
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
        dest.writeByte(this.pushFailed ? (byte)1 : 0);
        dest.writeByte(this.locked ? (byte)1 : 0);
    }

    protected Event(Parcel in) {
        this.id = (Long)in.readValue(Long.class.getClassLoader());
        this.UUID = in.readString();
        this.type = in.readString();
        this.timestamp = in.readLong();
        int changeParamsSize = in.readInt();
        this.changeParams = new HashMap<String, String>(changeParamsSize);
        for (int i = 0; i < changeParamsSize; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.changeParams.put(key, value);
        }
        int dataSize = in.readInt();
        this.data = new HashMap<String, String>(dataSize);
        for (int i = 0; i < dataSize; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.data.put(key, value);
        }
        this.pushFailed = in.readByte() != 0;
        this.locked = in.readByte() != 0;
    }
}

