/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.statistics.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import com.gymchina.statistics.converter.MapConverter;
import com.gymchina.statistics.dao.DaoSession;
import com.gymchina.statistics.entry.Event;
import java.util.Map;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.internal.DaoConfig;

public class EventDao
extends AbstractDao<Event, Long> {
    public static final String TABLENAME = "EVENT";
    private final MapConverter changeParamsConverter = new MapConverter();
    private final MapConverter dataConverter = new MapConverter();

    public EventDao(DaoConfig config) {
        super(config);
    }

    public EventDao(DaoConfig config, DaoSession daoSession) {
        super(config, (AbstractDaoSession)daoSession);
    }

    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists ? "IF NOT EXISTS " : "";
        db.execSQL("CREATE TABLE " + constraint + "\"EVENT\" (\"_id\" INTEGER PRIMARY KEY ,\"UUID\" TEXT UNIQUE ,\"TYPE\" TEXT,\"TIMESTAMP\" INTEGER NOT NULL ,\"CHANGE_PARAMS\" TEXT,\"DATA\" TEXT,\"PUSH_FAILED\" INTEGER NOT NULL ,\"LOCKED\" INTEGER NOT NULL );");
    }

    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"EVENT\"";
        db.execSQL(sql);
    }

    protected final void bindValues(DatabaseStatement stmt, Event entity) {
        Map<String, String> data;
        String type;
        String UUID;
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        if ((UUID = entity.getUUID()) != null) {
            stmt.bindString(2, UUID);
        }
        if ((type = entity.getType()) != null) {
            stmt.bindString(3, type);
        }
        stmt.bindLong(4, entity.getTimestamp());
        Map<String, String> changeParams = entity.getChangeParams();
        if (changeParams != null) {
            stmt.bindString(5, this.changeParamsConverter.convertToDatabaseValue(changeParams));
        }
        if ((data = entity.getData()) != null) {
            stmt.bindString(6, this.dataConverter.convertToDatabaseValue(data));
        }
        stmt.bindLong(7, entity.getPushFailed() ? 1L : 0L);
        stmt.bindLong(8, entity.getLocked() ? 1L : 0L);
    }

    protected final void bindValues(SQLiteStatement stmt, Event entity) {
        Map<String, String> data;
        String type;
        String UUID;
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        if ((UUID = entity.getUUID()) != null) {
            stmt.bindString(2, UUID);
        }
        if ((type = entity.getType()) != null) {
            stmt.bindString(3, type);
        }
        stmt.bindLong(4, entity.getTimestamp());
        Map<String, String> changeParams = entity.getChangeParams();
        if (changeParams != null) {
            stmt.bindString(5, this.changeParamsConverter.convertToDatabaseValue(changeParams));
        }
        if ((data = entity.getData()) != null) {
            stmt.bindString(6, this.dataConverter.convertToDatabaseValue(data));
        }
        stmt.bindLong(7, entity.getPushFailed() ? 1L : 0L);
        stmt.bindLong(8, entity.getLocked() ? 1L : 0L);
    }

    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0));
    }

    public Event readEntity(Cursor cursor, int offset) {
        Event entity = new Event(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), cursor.getLong(offset + 3), cursor.isNull(offset + 4) ? null : this.changeParamsConverter.convertToEntityProperty(cursor.getString(offset + 4)), cursor.isNull(offset + 5) ? null : this.dataConverter.convertToEntityProperty(cursor.getString(offset + 5)), cursor.getShort(offset + 6) != 0, cursor.getShort(offset + 7) != 0);
        return entity;
    }

    public void readEntity(Cursor cursor, Event entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)));
        entity.setUUID(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setType(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setTimestamp(cursor.getLong(offset + 3));
        entity.setChangeParams(cursor.isNull(offset + 4) ? null : this.changeParamsConverter.convertToEntityProperty(cursor.getString(offset + 4)));
        entity.setData(cursor.isNull(offset + 5) ? null : this.dataConverter.convertToEntityProperty(cursor.getString(offset + 5)));
        entity.setPushFailed(cursor.getShort(offset + 6) != 0);
        entity.setLocked(cursor.getShort(offset + 7) != 0);
    }

    protected final Long updateKeyAfterInsert(Event entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }

    public Long getKey(Event entity) {
        if (entity != null) {
            return entity.getId();
        }
        return null;
    }

    public boolean hasKey(Event entity) {
        return entity.getId() != null;
    }

    protected final boolean isEntityUpdateable() {
        return true;
    }

    public static class Properties {
        public static final Property Id = new Property(0, Long.class, "id", true, "_id");
        public static final Property UUID = new Property(1, String.class, "UUID", false, "UUID");
        public static final Property Type = new Property(2, String.class, "type", false, "TYPE");
        public static final Property Timestamp = new Property(3, Long.TYPE, "timestamp", false, "TIMESTAMP");
        public static final Property ChangeParams = new Property(4, String.class, "changeParams", false, "CHANGE_PARAMS");
        public static final Property Data = new Property(5, String.class, "data", false, "DATA");
        public static final Property PushFailed = new Property(6, Boolean.TYPE, "pushFailed", false, "PUSH_FAILED");
        public static final Property Locked = new Property(7, Boolean.TYPE, "locked", false, "LOCKED");
    }
}

