/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.statistics.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import com.gymchina.statistics.converter.MapConverter;
import com.gymchina.statistics.dao.DaoSession;
import com.gymchina.statistics.entry.Event;
import java.util.Map;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.internal.DaoConfig;

public class EventDao
extends AbstractDao<Event, String> {
    public static final String TABLENAME = "EVENT";
    private final MapConverter dataConverter = new MapConverter();

    public EventDao(DaoConfig config) {
        super(config);
    }

    public EventDao(DaoConfig config, DaoSession daoSession) {
        super(config, (AbstractDaoSession)daoSession);
    }

    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists ? "IF NOT EXISTS " : "";
        db.execSQL("CREATE TABLE " + constraint + "\"EVENT\" (\"UUID\" TEXT PRIMARY KEY NOT NULL ,\"TYPE\" TEXT,\"TIMESTAMP\" INTEGER NOT NULL ,\"DATA\" TEXT,\"PUSH_FAILED\" INTEGER NOT NULL ,\"LOCKED\" INTEGER NOT NULL );");
    }

    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"EVENT\"";
        db.execSQL(sql);
    }

    protected final void bindValues(DatabaseStatement stmt, Event entity) {
        String type;
        stmt.clearBindings();
        String UUID = entity.getUUID();
        if (UUID != null) {
            stmt.bindString(1, UUID);
        }
        if ((type = entity.getType()) != null) {
            stmt.bindString(2, type);
        }
        stmt.bindLong(3, entity.getTimestamp());
        Map<String, String> data = entity.getData();
        if (data != null) {
            stmt.bindString(4, this.dataConverter.convertToDatabaseValue(data));
        }
        stmt.bindLong(5, entity.getPushFailed() ? 1L : 0L);
        stmt.bindLong(6, entity.getLocked() ? 1L : 0L);
    }

    protected final void bindValues(SQLiteStatement stmt, Event entity) {
        String type;
        stmt.clearBindings();
        String UUID = entity.getUUID();
        if (UUID != null) {
            stmt.bindString(1, UUID);
        }
        if ((type = entity.getType()) != null) {
            stmt.bindString(2, type);
        }
        stmt.bindLong(3, entity.getTimestamp());
        Map<String, String> data = entity.getData();
        if (data != null) {
            stmt.bindString(4, this.dataConverter.convertToDatabaseValue(data));
        }
        stmt.bindLong(5, entity.getPushFailed() ? 1L : 0L);
        stmt.bindLong(6, entity.getLocked() ? 1L : 0L);
    }

    public String readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getString(offset + 0);
    }

    public Event readEntity(Cursor cursor, int offset) {
        Event entity = new Event(cursor.isNull(offset + 0) ? null : cursor.getString(offset + 0), cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), cursor.getLong(offset + 2), cursor.isNull(offset + 3) ? null : this.dataConverter.convertToEntityProperty(cursor.getString(offset + 3)), cursor.getShort(offset + 4) != 0, cursor.getShort(offset + 5) != 0);
        return entity;
    }

    public void readEntity(Cursor cursor, Event entity, int offset) {
        entity.setUUID(cursor.isNull(offset + 0) ? null : cursor.getString(offset + 0));
        entity.setType(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setTimestamp(cursor.getLong(offset + 2));
        entity.setData(cursor.isNull(offset + 3) ? null : this.dataConverter.convertToEntityProperty(cursor.getString(offset + 3)));
        entity.setPushFailed(cursor.getShort(offset + 4) != 0);
        entity.setLocked(cursor.getShort(offset + 5) != 0);
    }

    protected final String updateKeyAfterInsert(Event entity, long rowId) {
        return entity.getUUID();
    }

    public String getKey(Event entity) {
        if (entity != null) {
            return entity.getUUID();
        }
        return null;
    }

    public boolean hasKey(Event entity) {
        return entity.getUUID() != null;
    }

    protected final boolean isEntityUpdateable() {
        return true;
    }

    public static class Properties {
        public static final Property UUID = new Property(0, String.class, "UUID", true, "UUID");
        public static final Property Type = new Property(1, String.class, "type", false, "TYPE");
        public static final Property Timestamp = new Property(2, Long.TYPE, "timestamp", false, "TIMESTAMP");
        public static final Property Data = new Property(3, String.class, "data", false, "DATA");
        public static final Property PushFailed = new Property(4, Boolean.TYPE, "pushFailed", false, "PUSH_FAILED");
        public static final Property Locked = new Property(5, Boolean.TYPE, "locked", false, "LOCKED");
    }
}

