/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.statistics;

import android.app.Application;
import android.content.Context;
import com.gymchina.statistics.dao.DaoMaster;
import com.gymchina.statistics.dao.DaoSession;
import com.gymchina.statistics.dao.EventDao;
import com.gymchina.statistics.entry.Event;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.query.QueryBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0014J+\u0010\u0017\u001a\u0002H\u0018\"\u0010\b\u0000\u0010\u0018*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00108BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/gymchina/statistics/DaoManager;", "", "()V", "DB_NAME", "", "application", "Landroid/app/Application;", "daoHelper", "Lcom/gymchina/statistics/dao/DaoMaster$DevOpenHelper;", "getDaoHelper", "()Lcom/gymchina/statistics/dao/DaoMaster$DevOpenHelper;", "daoMaster", "Lcom/gymchina/statistics/dao/DaoMaster;", "getDaoMaster", "()Lcom/gymchina/statistics/dao/DaoMaster;", "daoSession", "Lcom/gymchina/statistics/dao/DaoSession;", "getDaoSession", "()Lcom/gymchina/statistics/dao/DaoSession;", "closeDaoHelper", "", "closeDaoSession", "closeDatabase", "dao", "DAO", "Lorg/greenrobot/greendao/AbstractDao;", "cls", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lorg/greenrobot/greendao/AbstractDao;", "init", "app", "debugMode", "", "setDebugMode", "debug", "statistics_release"})
public final class DaoManager {
    private static final String DB_NAME = "statistics.db";
    private static Application application;
    private static DaoMaster.DevOpenHelper daoHelper;
    private static DaoMaster daoMaster;
    private static DaoSession daoSession;
    public static final DaoManager INSTANCE;

    public final void init(@NotNull Application app, boolean debugMode) {
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        application = app;
        this.setDebugMode(debugMode);
    }

    private final DaoMaster.DevOpenHelper getDaoHelper() {
        if (daoHelper == null) {
            Application application = DaoManager.application;
            if (application == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"application");
            }
            daoHelper = new DaoMaster.DevOpenHelper((Context)application, DB_NAME, null);
        }
        return daoHelper;
    }

    private final DaoMaster getDaoMaster() {
        if (daoMaster == null) {
            DaoMaster.DevOpenHelper devOpenHelper = this.getDaoHelper();
            if (devOpenHelper == null) {
                Intrinsics.throwNpe();
            }
            daoMaster = new DaoMaster(devOpenHelper.getWritableDatabase());
        }
        return daoMaster;
    }

    private final DaoSession getDaoSession() {
        if (daoSession == null) {
            DaoMaster daoMaster = this.getDaoMaster();
            if (daoMaster == null) {
                Intrinsics.throwNpe();
            }
            daoSession = daoMaster.newSession();
        }
        return daoSession;
    }

    @NotNull
    public final synchronized <DAO extends AbstractDao<?, ?>> DAO dao(@NotNull Class<DAO> cls) {
        DaoSession daoSession;
        Intrinsics.checkParameterIsNotNull(cls, (String)"cls");
        String string = cls.getSimpleName();
        if (Intrinsics.areEqual((Object)string, (Object)Event.class.getSimpleName())) {
            daoSession = this.getDaoSession();
            if (daoSession == null) {
                Intrinsics.throwNpe();
            }
        } else {
            throw (Throwable)new NullPointerException("\u4f60\u8981\u83b7\u53d6\u7684DAO\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
        }
        EventDao eventDao = daoSession.getEventDao();
        if (eventDao == null) {
            throw new TypeCastException("null cannot be cast to non-null type DAO");
        }
        return (DAO)((Object)eventDao);
    }

    public final void setDebugMode(boolean debug) {
        QueryBuilder.LOG_SQL = debug;
        QueryBuilder.LOG_VALUES = debug;
    }

    public final void closeDatabase() {
        this.closeDaoSession();
        this.closeDaoHelper();
    }

    public final void closeDaoSession() {
        DaoSession daoSession = this.getDaoSession();
        if (daoSession != null) {
            daoSession.clear();
        }
        DaoManager.daoSession = null;
    }

    public final void closeDaoHelper() {
        DaoMaster.DevOpenHelper devOpenHelper = this.getDaoHelper();
        if (devOpenHelper != null) {
            devOpenHelper.close();
        }
        daoHelper = null;
    }

    private DaoManager() {
    }

    static {
        DaoManager daoManager;
        INSTANCE = daoManager = new DaoManager();
    }
}

