/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.statistics;

import android.content.Context;
import android.os.Build;
import androidx.annotation.Keep;
import com.gymchina.library.common.utils.AppUtil;
import com.gymchina.library.common.utils.DeviceUtil;
import com.gymchina.statistics.AbsPushTask;
import com.gymchina.statistics.Statistics;
import com.gymchina.statistics.utils.LogUtils;
import com.gymchina.statistics.utils.StatisticsUtils;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 \"2\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001\"B\u000f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001e\u001a\u00020\u0002J\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bR$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0019\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lcom/gymchina/statistics/Config;", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "ctx", "Landroid/content/Context;", "(Landroid/content/Context;)V", "value", "", "countPush", "getCountPush", "()I", "setCountPush", "(I)V", "countPushFailed", "getCountPushFailed", "setCountPushFailed", "debugMode", "", "getDebugMode", "()Z", "setDebugMode", "(Z)V", "pushClazz", "Ljava/lang/Class;", "Lcom/gymchina/statistics/AbsPushTask;", "getPushClazz", "()Ljava/lang/Class;", "setPushClazz", "(Ljava/lang/Class;)V", "getPushInfo", "needPush", "count", "failedCount", "Companion", "statistics_release"})
@Keep
public final class Config
extends HashMap<String, String> {
    private boolean debugMode;
    private int countPush;
    private int countPushFailed;
    @Nullable
    private Class<? extends AbsPushTask> pushClazz;
    @NotNull
    private static final String TAG;
    @NotNull
    public static final String PARAMS_APP_NAME = "app";
    private static final boolean DEFAULT_DEBUG_MODE = false;
    private static final int DEFAULT_COUNT_PUSH = 10;
    private static final int DEFAULT_COUNT_PUSH_FAILED = 5;
    public static final Companion Companion;

    public final boolean getDebugMode() {
        return this.debugMode;
    }

    public final void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    public final int getCountPush() {
        return this.countPush;
    }

    public final void setCountPush(int value) {
        if (value <= 0) {
            String msg = "\u4e0a\u62a5\u4e8b\u4ef6\u7684\u9600\u503c\u5fc5\u987b\u5927\u4e8e0";
            LogUtils.Companion.e$default(LogUtils.Companion, TAG, msg, null, 4, null);
            throw (Throwable)new Error(msg);
        }
        this.countPush = value;
    }

    public final int getCountPushFailed() {
        return this.countPushFailed;
    }

    public final void setCountPushFailed(int value) {
        if (value <= 0) {
            String msg = "\u4e0a\u62a5\u4e8b\u4ef6\u7684\u9600\u503c\u5fc5\u987b\u5927\u4e8e0";
            LogUtils.Companion.e$default(LogUtils.Companion, TAG, msg, null, 4, null);
            throw (Throwable)new Error(msg);
        }
        this.countPushFailed = value;
    }

    @Nullable
    public final Class<? extends AbsPushTask> getPushClazz() {
        return this.pushClazz;
    }

    public final void setPushClazz(@Nullable Class<? extends AbsPushTask> clazz) {
        this.pushClazz = clazz;
    }

    public final boolean needPush(int count, int failedCount) {
        return failedCount > 0 ? count >= this.countPushFailed : count >= this.countPush;
    }

    @NotNull
    public final String getPushInfo() {
        return StatisticsUtils.Companion.mapToString(this);
    }

    private Config(Context ctx) {
        this.put("platform", "and");
        this.put("brand", Build.BRAND);
        this.put("model", Build.MODEL);
        this.put("version", AppUtil.Companion.getVersionName(ctx));
        this.put("sid", DeviceUtil.Companion.getSid(ctx));
        this.countPush = 10;
        this.countPushFailed = 5;
    }

    static {
        Companion = new Companion(null);
        TAG = Statistics.Companion.getTAG() + '_' + Config.class.getSimpleName();
    }

    public /* synthetic */ Config(Context ctx, DefaultConstructorMarker $constructor_marker) {
        this(ctx);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/gymchina/statistics/Config$Companion;", "", "()V", "DEFAULT_COUNT_PUSH", "", "DEFAULT_COUNT_PUSH_FAILED", "DEFAULT_DEBUG_MODE", "", "PARAMS_APP_NAME", "", "TAG", "getTAG", "()Ljava/lang/String;", "default", "Lcom/gymchina/statistics/Config;", "ctx", "Landroid/content/Context;", "default$statistics_release", "statistics_release"})
    public static final class Companion {
        @NotNull
        public final String getTAG() {
            return TAG;
        }

        @NotNull
        public final Config default$statistics_release(@NotNull Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            return new Config(ctx, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

