/*
 * Decompiled with CFR 0.152.
 */
package notchtools.geek.com.notchtools.helper;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import notchtools.geek.com.notchtools.NotchTools;

public class NotchStatusBarUtils {
    private static int statusBarHeight = -1;

    public static int getStatusBarHeight(Context context) {
        int resId;
        if (statusBarHeight != -1) {
            return statusBarHeight;
        }
        if (statusBarHeight <= 0 && (resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android")) > 0) {
            statusBarHeight = context.getResources().getDimensionPixelSize(resId);
        }
        return statusBarHeight;
    }

    public static void setFullScreenWithSystemUi(final Window window, boolean setListener) {
        int systemUiVisibility = 0;
        WindowManager.LayoutParams attrs = window.getAttributes();
        attrs.flags |= 0x400;
        window.setAttributes(attrs);
        if (Build.VERSION.SDK_INT >= 16) {
            systemUiVisibility = 1542;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            systemUiVisibility |= 0x1000;
        }
        window.getDecorView().setSystemUiVisibility(systemUiVisibility);
        if (setListener) {
            window.getDecorView().setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

                public void onSystemUiVisibilityChange(int visibility) {
                    if (visibility == 0) {
                        NotchStatusBarUtils.setFullScreenWithSystemUi(window, false);
                    }
                }
            });
        }
    }

    public static void setFakeNotchView(Window window) {
        ViewGroup notchContainer = NotchStatusBarUtils.removeFakeNotchView(window);
        if (notchContainer == null) {
            return;
        }
        View view = new View(window.getContext());
        view.setLayoutParams(new ViewGroup.LayoutParams(-1, NotchTools.getFullScreenTools().getNotchHeight(window)));
        view.setBackgroundColor(-16777216);
        notchContainer.addView(view);
    }

    public static ViewGroup removeFakeNotchView(Window window) {
        ViewGroup notchContainer = NotchStatusBarUtils.getNotchContainer(window);
        if (notchContainer == null) {
            return null;
        }
        int childCount = notchContainer.getChildCount();
        if (childCount > 0) {
            notchContainer.removeAllViews();
        }
        return notchContainer;
    }

    public static ViewGroup getNotchContainer(Window window) {
        View decorView = window.getDecorView();
        if (decorView == null) {
            return null;
        }
        return (ViewGroup)decorView.findViewWithTag((Object)"notch_container");
    }
}

