/*
 * Decompiled with CFR 0.152.
 */
package notchtools.geek.com.notchtools.phone;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import notchtools.geek.com.notchtools.core.AbsNotchScreenSupport;
import notchtools.geek.com.notchtools.core.OnNotchCallBack;

public class HuaWeiNotchScreen
extends AbsNotchScreenSupport {
    private static final String TAG = HuaWeiNotchScreen.class.getSimpleName();
    private static final String DISPLAY_NOTCH_STATUS = "display_notch_status";
    public static final int FLAG_NOTCH_SUPPORT = 65536;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresApi(api=26)
    public boolean isNotchScreen(Window window) {
        boolean isNotchScreen = false;
        try {
            ClassLoader cl = window.getContext().getClassLoader();
            Class<?> HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = HwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
            isNotchScreen = (Boolean)get.invoke(HwNotchSizeUtil, new Object[0]);
            return isNotchScreen;
        }
        catch (ClassNotFoundException e) {
            Log.d((String)TAG, (String)"hasNotchInScreen ClassNotFoundException");
        }
        catch (NoSuchMethodException e) {
            Log.d((String)TAG, (String)"hasNotchInScreen NoSuchMethodException");
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"hasNotchInScreen Exception");
        }
        finally {
            return isNotchScreen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresApi(api=26)
    public int getNotchHeight(Window window) {
        if (!this.isNotchScreen(window)) {
            return 0;
        }
        int[] ret = new int[]{0, 0};
        try {
            ClassLoader cl = window.getContext().getClassLoader();
            Class<?> HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = HwNotchSizeUtil.getMethod("getNotchSize", new Class[0]);
            ret = (int[])get.invoke(HwNotchSizeUtil, new Object[0]);
            return (int)ret;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        catch (NoSuchMethodException noSuchMethodException) {}
        catch (Exception exception) {}
        finally {
            return ret[1];
        }
    }

    @Override
    @RequiresApi(api=26)
    public void fullScreenDontUseStatus(Activity activity, OnNotchCallBack notchCallBack) {
        super.fullScreenDontUseStatus(activity, notchCallBack);
        if (this.isNotchScreen(activity.getWindow())) {
            HuaWeiNotchScreen.setNotFullScreenWindowLayoutInDisplayCutout(activity.getWindow());
        }
    }

    @Override
    @RequiresApi(api=26)
    public void fullScreenUseStatus(Activity activity, OnNotchCallBack notchCallBack) {
        super.fullScreenUseStatus(activity, notchCallBack);
        if (this.isNotchScreen(activity.getWindow())) {
            HuaWeiNotchScreen.setFullScreenWindowLayoutInDisplayCutout(activity.getWindow());
        }
    }

    @TargetApi(value=19)
    public static void setFullScreenWindowLayoutInDisplayCutout(Window window) {
        if (window == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        try {
            Class<?> layoutParamsExCls = Class.forName("com.huawei.android.view.LayoutParamsEx");
            Constructor<?> con = layoutParamsExCls.getConstructor(WindowManager.LayoutParams.class);
            Object layoutParamsExObj = con.newInstance(layoutParams);
            Method method = layoutParamsExCls.getMethod("addHwFlags", Integer.TYPE);
            method.invoke(layoutParamsExObj, 65536);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.e((String)"test", (String)"hw add notch screen flag api error");
        }
        catch (Exception e) {
            Log.e((String)"test", (String)"other Exception");
        }
    }

    @RequiresApi(api=19)
    public static void setNotFullScreenWindowLayoutInDisplayCutout(Window window) {
        if (window == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        try {
            Class<?> layoutParamsExCls = Class.forName("com.huawei.android.view.LayoutParamsEx");
            Constructor<?> con = layoutParamsExCls.getConstructor(WindowManager.LayoutParams.class);
            Object layoutParamsExObj = con.newInstance(layoutParams);
            Method method = layoutParamsExCls.getMethod("clearHwFlags", Integer.TYPE);
            method.invoke(layoutParamsExObj, 65536);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.e((String)"test", (String)"hw clear notch screen flag api error");
        }
        catch (Exception e) {
            Log.e((String)"test", (String)"other Exception");
        }
    }

    private boolean isHideNotch(Context context) {
        int isNotchSwitchOpen = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)DISPLAY_NOTCH_STATUS, (int)0);
        return isNotchSwitchOpen == 1;
    }
}

