/*
 * Decompiled with CFR 0.152.
 */
package notchtools.geek.com.notchtools.helper;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class ThreadUtils {
    private static Handler sMainHandler;
    private static final Object sLock;
    private static Handler sLogicThreadHandler;
    private static final Object sLogicThreadHandlerLock;
    private static final Executor EXECUTOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Handler getUIThreadHandler() {
        Object object = sLock;
        synchronized (object) {
            if (sMainHandler == null) {
                sMainHandler = new Handler(Looper.getMainLooper());
            }
            return sMainHandler;
        }
    }

    public static boolean isMainThread() {
        return Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId();
    }

    public static boolean post2UI(Runnable r) {
        return ThreadUtils.getUIThreadHandler().post(r);
    }

    public static boolean post2UI(Context context, Runnable r) {
        if (context == null) {
            return ThreadUtils.post2UI(r);
        }
        return ThreadUtils.getUIThreadHandler().postAtTime(r, (Object)context.hashCode(), SystemClock.uptimeMillis());
    }

    public static boolean postDelayed2UI(Runnable r, long delayMillis) {
        return ThreadUtils.getUIThreadHandler().postDelayed(r, delayMillis);
    }

    public static boolean postDelayed2UI(Context context, Runnable r, long delayMillis) {
        if (context == null) {
            return ThreadUtils.postDelayed2UI(r, delayMillis);
        }
        return ThreadUtils.getUIThreadHandler().postAtTime(r, (Object)context.hashCode(), SystemClock.uptimeMillis() + delayMillis);
    }

    public static void cancelUITask(Runnable r) {
        ThreadUtils.getUIThreadHandler().removeCallbacks(r);
    }

    public static void cancelUITask(Context context) {
        if (context != null) {
            ThreadUtils.getUIThreadHandler().removeCallbacksAndMessages((Object)context.hashCode());
        }
    }

    private static boolean runningOnUI() {
        return ThreadUtils.getUIThreadHandler().getLooper() == Looper.myLooper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Handler getLogicThreadHandler() {
        Object object = sLogicThreadHandlerLock;
        synchronized (object) {
            if (sLogicThreadHandler == null) {
                HandlerThread t = new HandlerThread("daemon-handler-thread");
                t.start();
                sLogicThreadHandler = new Handler(t.getLooper());
            }
            return sLogicThreadHandler;
        }
    }

    public static boolean post2Logic(Runnable r) {
        return ThreadUtils.getLogicThreadHandler().post(r);
    }

    public static boolean post2Logic(Context context, Runnable r) {
        if (context == null) {
            return ThreadUtils.post2Logic(r);
        }
        return ThreadUtils.getLogicThreadHandler().postAtTime(r, (Object)context.hashCode(), SystemClock.uptimeMillis());
    }

    private static boolean postDelayed2Logic(Runnable r, long delayMillis) {
        return ThreadUtils.getLogicThreadHandler().postDelayed(r, delayMillis);
    }

    public static boolean postDelayed2Logic(Context context, Runnable r, long delayMillis) {
        if (context == null) {
            return ThreadUtils.postDelayed2Logic(r, delayMillis);
        }
        return ThreadUtils.getLogicThreadHandler().postAtTime(r, (Object)context.hashCode(), SystemClock.uptimeMillis() + delayMillis);
    }

    public static void cancelLogicTask(Runnable r) {
        ThreadUtils.getLogicThreadHandler().removeCallbacks(r);
    }

    public static void cancelLogicTask(Context context) {
        if (context != null) {
            ThreadUtils.getLogicThreadHandler().removeCallbacksAndMessages((Object)context.hashCode());
        }
    }

    public static void delayCancelLogicTask(Context context, long delayMillis) {
        if (context != null) {
            final Integer token = context.hashCode();
            ThreadUtils.postDelayed2Logic(new Runnable(){

                @Override
                public void run() {
                    ThreadUtils.getLogicThreadHandler().removeCallbacksAndMessages(token);
                }
            }, delayMillis);
        }
    }

    public static boolean runningOnLogic() {
        return ThreadUtils.getLogicThreadHandler().getLooper() == Looper.myLooper();
    }

    public static void safeCheckUIThread(String log) {
        if (!ThreadUtils.runningOnUI()) {
            throw new RuntimeException("ThreadUtils safeCheck alert " + log);
        }
    }

    public static String getThreadName() {
        return Thread.currentThread().getName() + " : " + Thread.currentThread().getId();
    }

    public static void exec(Runnable runnable) {
        if (runnable != null) {
            try {
                EXECUTOR.execute(runnable);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static <T> void exec(final Provider<T> provider, final Consumer<T> consumer) {
        if (provider == null) {
            return;
        }
        EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                Object tmp = null;
                try {
                    tmp = provider.provide();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (consumer == null) {
                    return;
                }
                final Object result = tmp;
                ThreadUtils.post2UI(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            consumer.consume(result);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    static {
        sLock = new Object();
        sLogicThreadHandlerLock = new Object();
        EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactory(){
            private int count = -1;

            @Override
            public Thread newThread(@NonNull Runnable r) {
                ++this.count;
                return new Thread(r, "ThreadUtils: " + this.count);
            }
        });
    }

    public static interface Consumer<T> {
        public void consume(@Nullable T var1);
    }

    public static interface Provider<T> {
        @Nullable
        public T provide();
    }
}

