/*
 * Decompiled with CFR 0.152.
 */
package notchtools.geek.com.notchtools;

import android.app.Activity;
import android.os.Build;
import android.view.Window;
import notchtools.geek.com.notchtools.core.INotchSupport;
import notchtools.geek.com.notchtools.core.OnNotchCallBack;
import notchtools.geek.com.notchtools.helper.DeviceBrandTools;
import notchtools.geek.com.notchtools.helper.NotchStatusBarUtils;
import notchtools.geek.com.notchtools.helper.ThreadUtils;
import notchtools.geek.com.notchtools.phone.CommonScreen;
import notchtools.geek.com.notchtools.phone.HuaWeiNotchScreen;
import notchtools.geek.com.notchtools.phone.MiuiNotchScreen;
import notchtools.geek.com.notchtools.phone.OppoNotchScreen;
import notchtools.geek.com.notchtools.phone.PVersionNotchScreen;
import notchtools.geek.com.notchtools.phone.VivoNotchScreen;

public class NotchTools
implements INotchSupport {
    private static NotchTools sFullScreenTolls;
    public static final String NOTCH_CONTAINER = "notch_container";
    private static final int CURRENT_SDK;
    public static final int VERSION_P = 28;
    private INotchSupport notchScreenSupport = null;
    private boolean mHasJudge;
    private boolean mIsNotchScreen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NotchTools getFullScreenTools() {
        if (sFullScreenTolls != null) return sFullScreenTolls;
        Class<NotchTools> clazz = NotchTools.class;
        synchronized (NotchTools.class) {
            if (sFullScreenTolls != null) return sFullScreenTolls;
            sFullScreenTolls = new NotchTools();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFullScreenTolls;
        }
    }

    private NotchTools() {
    }

    @Override
    public boolean isNotchScreen(Window Window2) {
        if (!this.mHasJudge) {
            if (this.notchScreenSupport == null) {
                this.checkScreenSupportInit(Window2);
            }
            if (this.notchScreenSupport == null) {
                this.mHasJudge = true;
                this.mIsNotchScreen = false;
            } else {
                this.mIsNotchScreen = this.notchScreenSupport.isNotchScreen(Window2);
            }
        }
        return this.mIsNotchScreen;
    }

    @Override
    public int getNotchHeight(Window window) {
        if (this.notchScreenSupport == null) {
            this.checkScreenSupportInit(window);
        }
        if (this.notchScreenSupport == null) {
            return 0;
        }
        return this.notchScreenSupport.getNotchHeight(window);
    }

    @Override
    public int getStatusHeight(Window window) {
        return NotchStatusBarUtils.getStatusBarHeight(window.getContext());
    }

    public void fullScreenDontUseStatus(Activity activity) {
        this.fullScreenDontUseStatus(activity, null);
    }

    @Override
    public void fullScreenDontUseStatus(final Activity activity, final OnNotchCallBack notchCallBack) {
        ThreadUtils.post2UI(new Runnable(){

            @Override
            public void run() {
                if (NotchTools.this.notchScreenSupport == null) {
                    NotchTools.this.checkScreenSupportInit(activity.getWindow());
                }
                if (NotchTools.this.notchScreenSupport != null) {
                    NotchTools.this.notchScreenSupport.fullScreenDontUseStatus(activity, notchCallBack);
                }
            }
        });
    }

    public void fullScreenDontUseStatusForPortrait(Activity activity) {
        this.fullScreenDontUseStatusForPortrait(activity, null);
    }

    @Override
    public void fullScreenDontUseStatusForPortrait(Activity activity, OnNotchCallBack notchCallBack) {
        this.fullScreenDontUseStatus(activity, notchCallBack);
    }

    public void fullScreenDontUseStatusForLandscape(Activity activity) {
        this.fullScreenDontUseStatusForLandscape(activity, null);
    }

    @Override
    public void fullScreenDontUseStatusForLandscape(final Activity activity, final OnNotchCallBack notchCallBack) {
        ThreadUtils.post2UI(new Runnable(){

            @Override
            public void run() {
                if (NotchTools.this.notchScreenSupport == null) {
                    NotchTools.this.checkScreenSupportInit(activity.getWindow());
                }
                if (NotchTools.this.notchScreenSupport != null) {
                    NotchTools.this.notchScreenSupport.fullScreenDontUseStatusForLandscape(activity, notchCallBack);
                }
            }
        });
    }

    public void fullScreenUseStatus(Activity activity) {
        this.fullScreenUseStatus(activity, null);
    }

    @Override
    public void fullScreenUseStatus(final Activity activity, final OnNotchCallBack notchCallBack) {
        ThreadUtils.post2UI(new Runnable(){

            @Override
            public void run() {
                if (NotchTools.this.notchScreenSupport == null) {
                    NotchTools.this.checkScreenSupportInit(activity.getWindow());
                }
                if (NotchTools.this.notchScreenSupport != null) {
                    NotchTools.this.notchScreenSupport.fullScreenUseStatus(activity, notchCallBack);
                }
            }
        });
    }

    private void checkScreenSupportInit(Window window) {
        if (this.notchScreenSupport != null) {
            return;
        }
        if (CURRENT_SDK < 26) {
            this.notchScreenSupport = new CommonScreen();
            return;
        }
        if (CURRENT_SDK < 28) {
            DeviceBrandTools deviceBrandTools = DeviceBrandTools.getInstance();
            this.notchScreenSupport = deviceBrandTools.isHuaWei() ? new HuaWeiNotchScreen() : (deviceBrandTools.isMiui() ? new MiuiNotchScreen() : (deviceBrandTools.isVivo() ? new VivoNotchScreen() : (deviceBrandTools.isOppo() ? new OppoNotchScreen() : new CommonScreen())));
            return;
        }
        if (CURRENT_SDK >= 28) {
            this.notchScreenSupport = new PVersionNotchScreen();
            return;
        }
    }

    static {
        CURRENT_SDK = Build.VERSION.SDK_INT;
    }
}

