/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.library.netclient;

import com.gymchina.library.netclient.AbsApi;
import com.gymchina.library.netclient.interceptor.BasicInfoInterceptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;
import retrofit2.Retrofit;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f\"\u000e\b\u0001\u0010 *\b\u0012\u0004\u0012\u0002H\u001f0\n2\u0006\u0010\u001e\u001a\u0002H \u00a2\u0006\u0002\u0010!J+\u0010\"\u001a\u00020#\"\u0004\b\u0000\u0010\u001f\"\u000e\b\u0001\u0010 *\b\u0012\u0004\u0012\u0002H\u001f0\n2\u0006\u0010\u001e\u001a\u0002H H\u0014\u00a2\u0006\u0002\u0010$J+\u0010%\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f\"\u000e\b\u0001\u0010 *\b\u0012\u0004\u0012\u0002H\u001f0\n2\u0006\u0010\u001e\u001a\u0002H H\u0016\u00a2\u0006\u0002\u0010!J\u0006\u0010&\u001a\u00020'R\u001c\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u001c\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007R\u0014\u0010\u001a\u001a\u00020\u001b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006)"}, d2={"Lcom/gymchina/library/netclient/AbsNetClient;", "", "()V", "allInterceptor", "", "Lokhttp3/Interceptor;", "getAllInterceptor", "()Ljava/util/List;", "apiSet", "", "Lcom/gymchina/library/netclient/AbsApi;", "basicHeaderLines", "", "getBasicHeaderLines", "basicInterceptor", "getBasicInterceptor", "()Lokhttp3/Interceptor;", "basicQueryParams", "Ljava/util/HashMap;", "getBasicQueryParams", "()Ljava/util/HashMap;", "converterFactory", "Lretrofit2/Converter$Factory;", "getConverterFactory", "networkInterceptor", "getNetworkInterceptor", "okHttpClient", "Lokhttp3/OkHttpClient;", "getOkHttpClient", "()Lokhttp3/OkHttpClient;", "api", "Interface", "Api", "(Lcom/gymchina/library/netclient/AbsApi;)Ljava/lang/Object;", "createRetrofit", "Lretrofit2/Retrofit;", "(Lcom/gymchina/library/netclient/AbsApi;)Lretrofit2/Retrofit;", "createService", "resetClient", "", "Companion", "library_release"})
public abstract class AbsNetClient {
    private final Set<AbsApi<?>> apiSet;
    public static final long CONNECT_TIMEOUT = 20L;
    public static final long WRITE_TIMEOUT = 15L;
    public static final long READ_TIMEOUT = 15L;
    public static final Companion Companion = new Companion(null);

    public final <Interface, Api extends AbsApi<Interface>> Interface api(@NotNull Api api) {
        Intrinsics.checkParameterIsNotNull(api, (String)"api");
        this.apiSet.add(api);
        return api.getInterface((AbsNetClient)this);
    }

    public final void resetClient() {
        Iterable $this$forEach$iv = this.apiSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbsApi it = (AbsApi)element$iv;
            boolean bl = false;
            it.resetInterface();
        }
    }

    public <Interface, Api extends AbsApi<Interface>> Interface createService(@NotNull Api api) {
        Intrinsics.checkParameterIsNotNull(api, (String)"api");
        return (Interface)this.createRetrofit(api).create(api.getServiceClass());
    }

    @NotNull
    protected <Interface, Api extends AbsApi<Interface>> Retrofit createRetrofit(@NotNull Api api) {
        Intrinsics.checkParameterIsNotNull(api, (String)"api");
        Retrofit.Builder builder = new Retrofit.Builder().baseUrl(api.getBaseUrl()).client(this.getOkHttpClient());
        List<Converter.Factory> converterFactory = this.getConverterFactory();
        Collection collection = converterFactory;
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            for (Converter.Factory cf : converterFactory) {
                builder.addConverterFactory(cf);
            }
        }
        Retrofit retrofit = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"builder.build()");
        return retrofit;
    }

    @NotNull
    protected OkHttpClient getOkHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(20L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).retryOnConnectionFailure(true);
        List<Interceptor> allInterceptor = this.getAllInterceptor();
        Collection collection = allInterceptor;
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            for (Interceptor interceptor : allInterceptor) {
                builder.addInterceptor(interceptor);
            }
        }
        List<Interceptor> networkInterceptor = this.getNetworkInterceptor();
        Collection collection2 = networkInterceptor;
        bl2 = false;
        boolean bl3 = false;
        if (!(collection2 == null || collection2.isEmpty())) {
            for (Interceptor interceptor : networkInterceptor) {
                builder.addNetworkInterceptor(interceptor);
            }
        }
        OkHttpClient okHttpClient = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"builder.build()");
        return okHttpClient;
    }

    @Nullable
    protected List<Converter.Factory> getConverterFactory() {
        return null;
    }

    @Nullable
    protected List<Interceptor> getNetworkInterceptor() {
        return null;
    }

    @Nullable
    protected List<Interceptor> getAllInterceptor() {
        Interceptor basicIt = this.getBasicInterceptor();
        return basicIt != null ? CollectionsKt.mutableListOf((Object[])new Interceptor[]{basicIt}) : null;
    }

    @Nullable
    protected Interceptor getBasicInterceptor() {
        BasicInfoInterceptor.Builder builder = null;
        if (this.getBasicQueryParams() != null) {
            builder = new BasicInfoInterceptor.Builder();
            HashMap<String, String> hashMap = this.getBasicQueryParams();
            if (hashMap == null) {
                Intrinsics.throwNpe();
            }
            builder.addQueryParamsMap((Map<String, String>)hashMap);
        }
        if (this.getBasicHeaderLines() != null) {
            BasicInfoInterceptor.Builder builder2 = builder;
            if (builder2 == null) {
                builder2 = new BasicInfoInterceptor.Builder();
            }
            builder = builder2;
            List<String> list = this.getBasicHeaderLines();
            if (list == null) {
                Intrinsics.throwNpe();
            }
            builder.addHeaderLinesList(list);
        }
        BasicInfoInterceptor.Builder builder3 = builder;
        return builder3 != null ? builder3.build() : null;
    }

    @Nullable
    protected HashMap<String, String> getBasicQueryParams() {
        return null;
    }

    @Nullable
    protected List<String> getBasicHeaderLines() {
        return null;
    }

    public AbsNetClient() {
        Set set;
        AbsNetClient absNetClient = this;
        boolean bl = false;
        absNetClient.apiSet = set = (Set)new LinkedHashSet();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/gymchina/library/netclient/AbsNetClient$Companion;", "", "()V", "CONNECT_TIMEOUT", "", "READ_TIMEOUT", "WRITE_TIMEOUT", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

