/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.library.netclient.interceptor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u0011H\u0002J.\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/gymchina/library/netclient/interceptor/BasicInfoInterceptor;", "Lokhttp3/Interceptor;", "()V", "headerLinesList", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "headerParamsMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "paramsMap", "queryParamsMap", "bodyToString", "request", "Lokhttp3/RequestBody;", "canInjectIntoBody", "", "Lokhttp3/Request;", "injectParamsIntoUrl", "httpUrlBuilder", "Lokhttp3/HttpUrl$Builder;", "requestBuilder", "Lokhttp3/Request$Builder;", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Builder", "library_release"})
public final class BasicInfoInterceptor
implements Interceptor {
    private final HashMap<String, String> queryParamsMap;
    private final HashMap<String, String> paramsMap;
    private final HashMap<String, String> headerParamsMap;
    private final ArrayList<String> headerLinesList;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Object line;
        Object value;
        Object key;
        Object object;
        Request request;
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request2 = request = chain.request();
        if (request2 == null) {
            Intrinsics.throwNpe();
        }
        Request.Builder requestBuilder = request2.newBuilder();
        Headers.Builder headerBuilder = request.headers().newBuilder();
        Object object2 = this.headerParamsMap;
        if (!object2.isEmpty()) {
            Map map = this.headerParamsMap;
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object2 = object.next();
                key = (String)entry.getKey();
                entry = object2;
                value = (String)entry.getValue();
                headerBuilder.add((String)key, (String)value);
            }
        }
        if (!(object2 = (Collection)this.headerLinesList).isEmpty()) {
            object = this.headerLinesList.iterator();
            while (object.hasNext()) {
                line = (String)object.next();
                headerBuilder.add((String)line);
            }
            requestBuilder.headers(headerBuilder.build());
        }
        if (!(line = (Map)this.queryParamsMap).isEmpty()) {
            HttpUrl.Builder builder = request.url().newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"request.url().newBuilder()");
            Request.Builder builder2 = requestBuilder;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"requestBuilder");
            request = this.injectParamsIntoUrl(builder, builder2, (Map<String, String>)this.queryParamsMap);
        }
        if (!(line = (Map)this.paramsMap).isEmpty() && this.canInjectIntoBody(request)) {
            FormBody.Builder formBodyBuilder = new FormBody.Builder();
            value = this.paramsMap;
            key = value.entrySet().iterator();
            while (key.hasNext()) {
                Object object3 = object = (Map.Entry)key.next();
                String key2 = (String)object3.getKey();
                object3 = object;
                String value2 = (String)object3.getValue();
                formBodyBuilder.add(key2, value2);
            }
            FormBody formBody = formBodyBuilder.build();
            Request request3 = request;
            if (request3 == null) {
                Intrinsics.throwNpe();
            }
            String postBodyString = this.bodyToString(request3.body());
            CharSequence charSequence = postBodyString;
            StringBuilder stringBuilder = new StringBuilder().append(postBodyString);
            boolean bl = charSequence.length() > 0;
            postBodyString = stringBuilder.append(bl ? "&" : "").append(this.bodyToString((RequestBody)formBody)).toString();
            requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded;charset=UTF-8"), (String)postBodyString));
        }
        Request request4 = request = requestBuilder.build();
        if (request4 == null) {
            Intrinsics.throwNpe();
        }
        Response response = chain.proceed(request4);
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"chain.proceed(request!!)");
        return response;
    }

    private final Request injectParamsIntoUrl(HttpUrl.Builder httpUrlBuilder, Request.Builder requestBuilder, Map<String, String> paramsMap) {
        Map<String, String> map = paramsMap;
        if (!map.isEmpty()) {
            Map<String, String> map2 = paramsMap;
            Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map<String, String> map3 = map = iterator.next();
                String key = (String)map3.getKey();
                map3 = map;
                String value = (String)map3.getValue();
                httpUrlBuilder.addQueryParameter(key, value);
            }
            requestBuilder.url(httpUrlBuilder.build());
            return requestBuilder.build();
        }
        return null;
    }

    private final boolean canInjectIntoBody(Request request) {
        if (request == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)"POST", (Object)request.method())) {
            return false;
        }
        RequestBody requestBody = request.body();
        if (requestBody == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)requestBody, (String)"request.body() ?: return false");
        RequestBody body = requestBody;
        MediaType mediaType = body.contentType();
        if (mediaType == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)mediaType, (String)"body.contentType() ?: return false");
        MediaType mediaType2 = mediaType;
        return Intrinsics.areEqual((Object)"x-www-form-urlencoded", (Object)mediaType2.subtype());
    }

    private final String bodyToString(RequestBody request) {
        try {
            Buffer buffer = new Buffer();
            if (request == null) {
                return "";
            }
            request.writeTo((BufferedSink)buffer);
            String string = buffer.readUtf8();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.readUtf8()");
            return string;
        }
        catch (IOException e) {
            return "did not work";
        }
    }

    private BasicInfoInterceptor() {
        BasicInfoInterceptor basicInfoInterceptor = this;
        Cloneable cloneable = new HashMap();
        basicInfoInterceptor.queryParamsMap = cloneable;
        basicInfoInterceptor = this;
        cloneable = new HashMap();
        basicInfoInterceptor.paramsMap = cloneable;
        basicInfoInterceptor = this;
        cloneable = new HashMap();
        basicInfoInterceptor.headerParamsMap = cloneable;
        basicInfoInterceptor = this;
        cloneable = new ArrayList();
        basicInfoInterceptor.headerLinesList = cloneable;
    }

    public /* synthetic */ BasicInfoInterceptor(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\u001a\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010J\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\u001a\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\u001a\u0010\u0015\u001a\u00020\u00002\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010J\u0006\u0010\u0017\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/gymchina/library/netclient/interceptor/BasicInfoInterceptor$Builder;", "", "()V", "interceptor", "Lcom/gymchina/library/netclient/interceptor/BasicInfoInterceptor;", "addHeaderLine", "headerLine", "", "addHeaderLinesList", "headerLinesList", "", "addHeaderParam", "key", "value", "addHeaderParamsMap", "headerParamsMap", "", "addParam", "addParamsMap", "paramsMap", "addQueryParam", "addQueryParamsMap", "queryParamsMap", "build", "library_release"})
    public static final class Builder {
        private final BasicInfoInterceptor interceptor = new BasicInfoInterceptor(null);

        @NotNull
        public final BasicInfoInterceptor build() {
            return this.interceptor;
        }

        @NotNull
        public final Builder addParam(@NotNull String key, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Map map = this.interceptor.paramsMap;
            String string = value;
            map.put(key, string);
            return this;
        }

        @NotNull
        public final Builder addParamsMap(@NotNull Map<String, String> paramsMap) {
            Intrinsics.checkParameterIsNotNull(paramsMap, (String)"paramsMap");
            this.interceptor.paramsMap.putAll(paramsMap);
            return this;
        }

        @NotNull
        public final Builder addHeaderParam(@NotNull String key, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Map map = this.interceptor.headerParamsMap;
            String string = value;
            map.put(key, string);
            return this;
        }

        @NotNull
        public final Builder addHeaderParamsMap(@NotNull Map<String, String> headerParamsMap) {
            Intrinsics.checkParameterIsNotNull(headerParamsMap, (String)"headerParamsMap");
            this.interceptor.headerParamsMap.putAll(headerParamsMap);
            return this;
        }

        @NotNull
        public final Builder addHeaderLine(@NotNull String headerLine) {
            Intrinsics.checkParameterIsNotNull((Object)headerLine, (String)"headerLine");
            int index = StringsKt.indexOf$default((CharSequence)headerLine, (String)":", (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                throw (Throwable)new IllegalArgumentException("Unexpected header: " + headerLine);
            }
            this.interceptor.headerLinesList.add(headerLine);
            return this;
        }

        @NotNull
        public final Builder addHeaderLinesList(@NotNull List<String> headerLinesList) {
            Intrinsics.checkParameterIsNotNull(headerLinesList, (String)"headerLinesList");
            for (String headerLine : headerLinesList) {
                int index = StringsKt.indexOf$default((CharSequence)headerLine, (String)":", (int)0, (boolean)false, (int)6, null);
                if (index == -1) {
                    throw (Throwable)new IllegalArgumentException("Unexpected header: " + headerLine);
                }
                this.interceptor.headerLinesList.add(headerLine);
            }
            return this;
        }

        @NotNull
        public final Builder addQueryParam(@NotNull String key, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Map map = this.interceptor.queryParamsMap;
            String string = value;
            map.put(key, string);
            return this;
        }

        @NotNull
        public final Builder addQueryParamsMap(@NotNull Map<String, String> queryParamsMap) {
            Intrinsics.checkParameterIsNotNull(queryParamsMap, (String)"queryParamsMap");
            this.interceptor.queryParamsMap.putAll(queryParamsMap);
            return this;
        }
    }
}

