/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.library.common.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/gymchina/library/common/utils/SoftKeyboardUtil;", "", "()V", "Companion", "library_release"})
public final class SoftKeyboardUtil {
    public static final Companion Companion = new Companion(null);

    private SoftKeyboardUtil() {
        throw (Throwable)new Error("cannot be instantiated");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ*\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u001b"}, d2={"Lcom/gymchina/library/common/utils/SoftKeyboardUtil$Companion;", "", "()V", "clip", "", "context", "Landroid/content/Context;", "text", "", "closeKeyboard", "activity", "Landroid/app/Activity;", "dialog", "Landroid/app/Dialog;", "handleAutoCloseKeyboard", "isAutoCloseKeyboard", "", "currentFocusView", "Landroid/view/View;", "motionEvent", "Landroid/view/MotionEvent;", "dialogOrActivity", "isActive", "openKeyboard", "editText", "Landroid/widget/EditText;", "toggleKeyboard", "library_release"})
    public static final class Companion {
        public final void closeKeyboard(@NotNull Activity activity) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            try {
                View view = activity.getWindow().peekDecorView();
                if (view != null) {
                    Object object = activity.getSystemService("input_method");
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
                    }
                    InputMethodManager inputMethodManager = (InputMethodManager)object;
                    inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public final void closeKeyboard(@NotNull Dialog dialog) {
            Intrinsics.checkParameterIsNotNull((Object)dialog, (String)"dialog");
            try {
                View view;
                Window window = dialog.getWindow();
                if (window != null && (view = window.peekDecorView()) != null) {
                    Object object = dialog.getContext().getSystemService("input_method");
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
                    }
                    InputMethodManager inputMethodManager = (InputMethodManager)object;
                    inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public final void openKeyboard(@NotNull Context context, @NotNull EditText editText) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
            new Handler().postDelayed(new Runnable(editText, context){
                final /* synthetic */ EditText $editText;
                final /* synthetic */ Context $context;

                public final void run() {
                    this.$editText.requestFocus();
                    this.$editText.setSelection(this.$editText.getText().toString().length());
                    Object object = this.$context.getSystemService("input_method");
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
                    }
                    InputMethodManager imm = (InputMethodManager)object;
                    imm.showSoftInput((View)this.$editText, 2);
                }
                {
                    this.$editText = editText;
                    this.$context = context;
                }
            }, 300L);
        }

        @SuppressLint(value={"ObsoleteSdkInt"})
        public final void clip(@NotNull Context context, @NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            if (Build.VERSION.SDK_INT < 11) {
                Object object = context.getSystemService("clipboard");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.text.ClipboardManager");
                }
                android.text.ClipboardManager clipboardManager = (android.text.ClipboardManager)object;
                clipboardManager.setText((CharSequence)text);
            } else {
                Object object = context.getSystemService("clipboard");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.content.ClipboardManager");
                }
                ClipboardManager clipboardManager = (ClipboardManager)object;
                clipboardManager.setPrimaryClip(ClipData.newPlainText((CharSequence)"content", (CharSequence)text));
            }
        }

        public final void toggleKeyboard(@NotNull Activity activity) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            Object object = activity.getSystemService("input_method");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
            }
            InputMethodManager inputMethodManager = (InputMethodManager)object;
            if (inputMethodManager.isActive()) {
                inputMethodManager.toggleSoftInput(0, 2);
            }
        }

        public final void handleAutoCloseKeyboard(boolean isAutoCloseKeyboard, @Nullable View currentFocusView, @NotNull MotionEvent motionEvent, @Nullable Object dialogOrActivity) {
            Intrinsics.checkParameterIsNotNull((Object)motionEvent, (String)"motionEvent");
            if (isAutoCloseKeyboard && motionEvent.getAction() == 0 && currentFocusView != null && currentFocusView instanceof EditText && dialogOrActivity != null) {
                int[] leftTop = new int[]{0, 0};
                currentFocusView.getLocationInWindow(leftTop);
                int left = leftTop[0];
                int top = leftTop[1];
                int bottom = top + ((EditText)currentFocusView).getHeight();
                int right = left + ((EditText)currentFocusView).getWidth();
                if (!(motionEvent.getX() > (float)left && motionEvent.getX() < (float)right && motionEvent.getY() > (float)top && motionEvent.getY() < (float)bottom)) {
                    if (dialogOrActivity instanceof Dialog) {
                        this.closeKeyboard((Dialog)dialogOrActivity);
                    } else if (dialogOrActivity instanceof Activity) {
                        this.closeKeyboard((Activity)dialogOrActivity);
                    }
                }
            }
        }

        public final boolean isActive(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            try {
                Object object = context.getSystemService("input_method");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
                }
                InputMethodManager imm = (InputMethodManager)object;
                return imm.isActive();
            }
            catch (Exception exception) {
                return false;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

