/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.library.common.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import com.gymchina.library.common.utils.Preference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/gymchina/library/common/utils/GetDeviceId;", "", "()V", "Companion", "library_release"})
public final class GetDeviceId {
    private static final String CACHE_DIR = ".gymchina/cache/devices";
    private static final String CACHE_FILE_NAME = ".DEVICES";
    private static final String SP_DEVICE_SID = "device_sid_2";
    public static final Companion Companion = new Companion(null);

    private GetDeviceId() {
        throw (Throwable)new Error("Do not need instantiate!");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0003J\b\u0010\u0015\u001a\u00020\u0004H\u0002J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u001a\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c\u00b2\u0006\n\u0010\u001d\u001a\u00020\u0004X\u008a\u008e\u0002\u00b2\u0006\n\u0010\u001d\u001a\u00020\u0004X\u008a\u008e\u0002"}, d2={"Lcom/gymchina/library/common/utils/GetDeviceId$Companion;", "", "()V", "CACHE_DIR", "", "CACHE_FILE_NAME", "SP_DEVICE_SID", "bytesToHex", "bytes", "", "upperCase", "", "createDeviceId", "context", "Landroid/content/Context;", "getCacheDeviceID", "getCacheFileOnSDCard", "Ljava/io/File;", "getDeviceId", "getDeviceIdOnSDCard", "getIMIEStatus", "getLocalMac", "getMD5", "message", "init", "", "saveDeviceID", "deviceId", "library_release", "spDeviceId"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty0((MutablePropertyReference0)new MutablePropertyReference0Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "spDeviceId", "<v#0>")), (KProperty)Reflection.mutableProperty0((MutablePropertyReference0)new MutablePropertyReference0Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "spDeviceId", "<v#1>"))};
        }

        public final void init(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            new Thread(new Runnable(context){
                final /* synthetic */ Context $context;

                public final void run() {
                    try {
                        String string = com.gymchina.library.common.utils.GetDeviceId$Companion.access$getCacheDeviceID(GetDeviceId.Companion, this.$context);
                        if (string == null) {
                            string = "";
                        }
                        String sdDeviceId = string;
                        KProperty kProperty = com.gymchina.library.common.utils.GetDeviceId$Companion.$$delegatedProperties[0];
                        Preference<String> spDeviceId = new Preference<String>("device_sid_2", "", this.$context, null, 8, null);
                        CharSequence charSequence = (CharSequence)spDeviceId.getValue(null, kProperty);
                        boolean bl = false;
                        if (charSequence.length() > 0) {
                            charSequence = sdDeviceId;
                            bl = false;
                            if (charSequence.length() == 0 || Intrinsics.areEqual((Object)sdDeviceId, (Object)((String)spDeviceId.getValue(null, kProperty))) ^ true) {
                                com.gymchina.library.common.utils.GetDeviceId$Companion.access$saveDeviceID(GetDeviceId.Companion, this.$context, (String)spDeviceId.getValue(null, kProperty));
                            }
                        } else {
                            charSequence = sdDeviceId;
                            bl = false;
                            if (charSequence.length() == 0) {
                                spDeviceId.setValue(null, kProperty, com.gymchina.library.common.utils.GetDeviceId$Companion.access$getDeviceIdOnSDCard(GetDeviceId.Companion, this.$context));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                {
                    this.$context = context;
                }
            }).start();
        }

        @NotNull
        public final String getDeviceId(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            KProperty kProperty = $$delegatedProperties[1];
            Preference<String> spDeviceId = new Preference<String>(GetDeviceId.SP_DEVICE_SID, "", context, null, 8, null);
            CharSequence charSequence = (CharSequence)spDeviceId.getValue(null, kProperty);
            boolean bl = false;
            if (charSequence.length() == 0) {
                spDeviceId.setValue(null, kProperty, this.createDeviceId(context));
            }
            return (String)spDeviceId.getValue(null, kProperty);
        }

        private final String getDeviceIdOnSDCard(Context context) {
            String sdDeviceId = this.getCacheDeviceID(context);
            CharSequence charSequence = sdDeviceId;
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                return sdDeviceId;
            }
            String deviceId = this.createDeviceId(context);
            CharSequence charSequence2 = deviceId;
            bl2 = false;
            if (charSequence2.length() > 0) {
                this.saveDeviceID(context, deviceId);
            }
            return deviceId;
        }

        private final String createDeviceId(Context context) {
            StringBuffer s = new StringBuffer();
            try {
                s.append(this.getIMIEStatus(context));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                s.append(StringsKt.replace$default((String)this.getLocalMac(), (String)":", (String)"", (boolean)false, (int)4, null));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CharSequence charSequence = s;
            boolean bl = false;
            if (charSequence.length() == 0) {
                String string = UUID.randomUUID().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
                s.append(StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null));
            }
            String string = s.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"s.toString()");
            return this.getMD5(string, false);
        }

        private final String getCacheDeviceID(Context context) {
            StringBuffer buffer = new StringBuffer();
            try {
                File file = this.getCacheFileOnSDCard(context);
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                Reader reader = new BufferedReader(isr);
                Ref.IntRef i = new Ref.IntRef();
                while (true) {
                    int n = reader.read();
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = n;
                    boolean bl3 = false;
                    i.element = it;
                    if (n <= -1) break;
                    buffer.append((char)i.element);
                }
                reader.close();
                return buffer.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @SuppressLint(value={"HardwareIds"})
        private final String getIMIEStatus(Context context) {
            String string;
            Object object = context.getSystemService("phone");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
            }
            TelephonyManager tm = (TelephonyManager)object;
            if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
                string = "";
            } else {
                String string2 = tm.getDeviceId();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tm.deviceId");
            }
            return string;
        }

        private final String getLocalMac() {
            String macAddress = "";
            try {
                NetworkInterface networkInterface = NetworkInterface.getByName("eth1");
                if (networkInterface == null) {
                    networkInterface = NetworkInterface.getByName("wlan0");
                }
                if (networkInterface != null) {
                    byte[] address;
                    StringBuffer buf = new StringBuffer();
                    for (byte b : address = networkInterface.getHardwareAddress()) {
                        String string;
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string2 = "%02X:";
                        Object[] objectArray = new Object[]{b};
                        StringBuffer stringBuffer = buf;
                        boolean bl = false;
                        Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                        stringBuffer.append(string);
                    }
                    CharSequence charSequence = buf;
                    int n = 0;
                    if (charSequence.length() > 0) {
                        buf.deleteCharAt(buf.length() - 1);
                    }
                    String string = buf.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buf.toString()");
                    macAddress = string;
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            return macAddress;
        }

        private final void saveDeviceID(Context context, String deviceId) {
            try {
                File file = this.getCacheFileOnSDCard(context);
                Writer out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                out.write(deviceId);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private final File getCacheFileOnSDCard(Context context) {
            File file;
            File cacheDir;
            File file2 = cacheDir = Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted") ? new File(Environment.getExternalStorageDirectory(), GetDeviceId.CACHE_DIR) : new File(context.getFilesDir(), GetDeviceId.CACHE_DIR);
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
            if (!(file = new File(cacheDir, GetDeviceId.CACHE_FILE_NAME)).exists()) {
                file.createNewFile();
            }
            return file;
        }

        private final String getMD5(String message, boolean upperCase) {
            String md5str = "";
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                String string = message;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] input = byArray;
                byte[] buff = md.digest(input);
                Intrinsics.checkExpressionValueIsNotNull((Object)buff, (String)"buff");
                md5str = this.bytesToHex(buff, upperCase);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return md5str;
        }

        /*
         * WARNING - void declaration
         */
        private final String bytesToHex(byte[] bytes, boolean upperCase) {
            String string;
            StringBuffer md5str = new StringBuffer();
            int digital = 0;
            int n = 0;
            int n2 = bytes.length;
            while (n < n2) {
                void i;
                digital = bytes[i];
                if (digital < 0) {
                    digital += 256;
                }
                if (digital < 16) {
                    md5str.append("0");
                }
                md5str.append(Integer.toHexString(digital));
                ++i;
            }
            if (upperCase) {
                String string2 = md5str.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"md5str.toString()");
                String string3 = string2;
                Locale locale = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toUpperCase(locale2);
                string = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase(locale)");
            } else {
                String string6 = md5str.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"md5str.toString()");
                String string7 = string6;
                Locale locale = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
                Locale locale3 = locale;
                boolean bl = false;
                String string8 = string7;
                if (string8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.toLowerCase(locale3);
                string = string9;
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).toLowerCase(locale)");
            }
            return string;
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$getCacheDeviceID(Companion $this, Context context) {
            return $this.getCacheDeviceID(context);
        }

        public static final /* synthetic */ void access$saveDeviceID(Companion $this, Context context, String deviceId) {
            $this.saveDeviceID(context, deviceId);
        }

        public static final /* synthetic */ String access$getDeviceIdOnSDCard(Companion $this, Context context) {
            return $this.getDeviceIdOnSDCard(context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

