/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.library.common.utils;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.NotificationManagerCompat;
import com.gymchina.library.common.utils.PermissionUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/gymchina/library/common/utils/NotificationUtil;", "", "()V", "Companion", "library_release"})
public final class NotificationUtil {
    public static final Companion Companion = new Companion(null);

    private NotificationUtil() {
        throw (Throwable)new Error("\u4e0d\u80fd\u521d\u59cb\u5316\u8be5\u7c7b\uff01");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lcom/gymchina/library/common/utils/NotificationUtil$Companion;", "", "()V", "areNotificationsEnabled", "", "ctx", "Landroid/content/Context;", "getSafeIntentForOppo", "Landroid/content/Intent;", "getSafeIntentForVivo", "toSetNotification", "", "library_release"})
    public static final class Companion {
        public final boolean areNotificationsEnabled(@NotNull Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            return NotificationManagerCompat.from((Context)ctx).areNotificationsEnabled();
        }

        public final void toSetNotification(@NotNull Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intent intent = this.getSafeIntentForVivo(ctx);
            if (intent != null) {
                ctx.startActivity(intent);
                return;
            }
            intent = this.getSafeIntentForOppo(ctx);
            if (intent != null) {
                ctx.startActivity(intent);
                return;
            }
            if (Build.VERSION.SDK_INT >= 26) {
                try {
                    Intent intent2 = new Intent();
                    Context context = ctx;
                    Intent $receiver = intent2;
                    $receiver.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                    $receiver.putExtra("android.provider.extra.APP_PACKAGE", ctx.getPackageName());
                    Intent intent3 = intent2;
                    context.startActivity(intent3);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PermissionUtil.Companion.toPermissionSetting(ctx);
                }
            } else if (Build.VERSION.SDK_INT >= 21) {
                try {
                    Intent e = new Intent();
                    Context context = ctx;
                    Intent $receiver = e;
                    $receiver.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                    $receiver.putExtra("app_package", ctx.getPackageName());
                    $receiver.putExtra("app_uid", ctx.getApplicationInfo().uid);
                    Intent intent4 = e;
                    context.startActivity(intent4);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PermissionUtil.Companion.toPermissionSetting(ctx);
                }
            } else {
                PermissionUtil.Companion.toPermissionSetting(ctx);
            }
        }

        @Nullable
        public final Intent getSafeIntentForVivo(@NotNull Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            return ctx.getPackageManager().getLaunchIntentForPackage("com.iqoo.secure");
        }

        @Nullable
        public final Intent getSafeIntentForOppo(@NotNull Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            return ctx.getPackageManager().getLaunchIntentForPackage("com.oppo.safe");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

