/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.library.common.utils;

import com.gymchina.library.common.utils.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/gymchina/library/common/utils/FileUtil;", "", "()V", "Companion", "library_release"})
public final class FileUtil {
    public static final long B = 1L;
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final Companion Companion = new Companion(null);

    private FileUtil() {
        throw (Throwable)new Error("cannot be instantiated");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0016J\u0018\u0010\u001a\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u0016J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0016J\u0012\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010\"\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010#\u001a\u00020\u0016J\u0016\u0010\"\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/gymchina/library/common/utils/FileUtil$Companion;", "", "()V", "B", "", "GB", "KB", "MB", "closeIO", "", "closeables", "", "Ljava/io/Closeable;", "([Ljava/io/Closeable;)V", "createFileByDeleteOldFile", "", "file", "Ljava/io/File;", "createOrExistsDir", "deleteAllInDir", "dir", "dirPath", "", "deleteDir", "deleteFile", "srcFilePath", "deleteFilesInDirWithFilter", "filter", "Ljava/io/FileFilter;", "getFileByPath", "filePath", "getFileSize", "isSpace", "s", "rename", "newName", "library_release"})
    public static final class Companion {
        public final boolean deleteAllInDir(@NotNull String dirPath) {
            Intrinsics.checkParameterIsNotNull((Object)dirPath, (String)"dirPath");
            return this.deleteAllInDir(this.getFileByPath(dirPath));
        }

        public final boolean deleteAllInDir(@Nullable File dir) {
            return this.deleteFilesInDirWithFilter(dir, deleteAllInDir.1.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean deleteFilesInDirWithFilter(@Nullable File dir, @NotNull FileFilter filter) {
            File[] fileArray;
            File[] fileArray2;
            Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
            if (dir == null) {
                return false;
            }
            if (!dir.exists()) {
                return true;
            }
            if (!dir.isDirectory()) {
                return false;
            }
            File[] files = dir.listFiles();
            if (files != null && !((fileArray2 = (fileArray = files)).length == 0)) {
                File[] var3 = files;
                int var4 = files.length;
                int n = 0;
                int n2 = var4;
                while (n < n2) {
                    void var5;
                    File file = var3[var5];
                    if (filter.accept(file)) {
                        File file2 = file;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                        if (file2.isFile() ? !file.delete() : file.isDirectory() && !this.deleteDir(file)) {
                            return false;
                        }
                    }
                    ++var5;
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean deleteDir(@Nullable File dir) {
            File[] fileArray;
            File[] fileArray2;
            if (dir == null) {
                return false;
            }
            if (!dir.exists()) {
                return true;
            }
            if (!dir.isDirectory()) {
                return false;
            }
            File[] files = dir.listFiles();
            if (files != null && !((fileArray2 = (fileArray = files)).length == 0)) {
                File[] var2 = files;
                int var3 = files.length;
                int n = 0;
                int n2 = var3;
                while (n < n2) {
                    void var4;
                    File file;
                    File file2 = file = var2[var4];
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                    if (file2.isFile() ? !file.delete() : file.isDirectory() && !this.deleteDir(file)) {
                        return false;
                    }
                    ++var4;
                }
            }
            return dir.delete();
        }

        public final boolean deleteFile(@NotNull String srcFilePath) {
            Intrinsics.checkParameterIsNotNull((Object)srcFilePath, (String)"srcFilePath");
            return this.deleteFile(this.getFileByPath(srcFilePath));
        }

        public final boolean deleteFile(@Nullable File file) {
            return file != null && (!file.exists() || file.isFile() && file.delete());
        }

        @Nullable
        public final File getFileByPath(@NotNull String filePath) {
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            return this.isSpace(filePath) ? null : new File(filePath);
        }

        private final boolean isSpace(String s) {
            if (s == null) {
                return true;
            }
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        public final boolean createFileByDeleteOldFile(@Nullable File file) {
            boolean bl;
            if (file == null) {
                bl = false;
            } else if (file.exists() && !file.delete()) {
                bl = false;
            } else if (!this.createOrExistsDir(file.getParentFile())) {
                bl = false;
            } else {
                boolean bl2;
                try {
                    bl2 = file.createNewFile();
                }
                catch (Throwable var2) {
                    bl2 = false;
                }
                bl = bl2;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final void closeIO(Closeable ... closeables) {
            Intrinsics.checkParameterIsNotNull((Object)closeables, (String)"closeables");
            Closeable[] var1 = closeables;
            int var2 = closeables.length;
            int n = 0;
            int n2 = var2;
            while (n < n2) {
                void var3;
                Closeable closeable = var1[var3];
                try {
                    closeable.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++var3;
            }
        }

        public final boolean rename(@NotNull String filePath, @NotNull String newName) {
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
            return this.rename(this.getFileByPath(filePath), newName);
        }

        public final boolean rename(@Nullable File file, @NotNull String newName) {
            File newFile;
            Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
            return file == null ? false : (!file.exists() ? false : (this.isSpace(newName) ? false : (Intrinsics.areEqual((Object)newName, (Object)file.getName()) ? true : !(newFile = new File(file.getParent() + File.separator + newName)).exists() && file.renameTo(newFile))));
        }

        public final boolean createOrExistsDir(@Nullable File file) {
            return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
        }

        public final long getFileSize(@NotNull String filePath) {
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            return this.getFileSize(new File(filePath));
        }

        public final long getFileSize(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            long size = 0L;
            if (file.exists()) {
                try {
                    size = file.length();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return size;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

