/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.library.common.extend;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.gymchina.library.common.extend.CastKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\b\u00a8\u0006\u0007"}, d2={"drawable2Bitmap", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "maxDims", "", "toBitmap", "library_release"})
public final class DrawableKt {
    @NotNull
    public static final Bitmap drawable2Bitmap(@NotNull Drawable drawable, int maxDims) {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        int actualWidth = Math.max(1, drawable.getIntrinsicWidth());
        int actualHeight = Math.max(1, drawable.getIntrinsicHeight());
        double scaleWidth = (double)maxDims / (double)actualWidth;
        double scaleHeight = (double)maxDims / (double)actualHeight;
        double scale = Math.min(1.0, Math.min(scaleWidth, scaleHeight));
        int width = (int)((double)actualWidth * scale);
        int height = (int)((double)actualHeight * scale);
        if (drawable instanceof BitmapDrawable) {
            Bitmap bitmap2 = ((BitmapDrawable)CastKt.cast(drawable)).getBitmap();
            Bitmap bitmap3 = actualWidth != width || actualHeight != height ? Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)width, (int)height, (boolean)false) : bitmap2;
            bitmap = bitmap3;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"if (actualWidth != width\u2026se)\n        } else bitmap");
        } else {
            Bitmap bitmap4 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap4);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            Bitmap bitmap5 = bitmap4;
            bitmap = bitmap5;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"bitmap");
        }
        return bitmap;
    }

    @NotNull
    public static final Bitmap toBitmap(@NotNull Drawable $receiver, int maxDims) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return DrawableKt.drawable2Bitmap($receiver, maxDims);
    }
}

