/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.library.common.utils;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.gymchina.library.common.extend.CastKt;
import com.gymchina.library.common.utils.Preference;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/gymchina/library/common/utils/DeviceUtil;", "", "()V", "Companion", "library_release"})
public final class DeviceUtil {
    public static final Companion Companion = new Companion(null);

    private DeviceUtil() {
        throw (Throwable)new Error("Do not need instantiate!");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000b\u00b2\u0006\n\u0010\f\u001a\u00020\u0004X\u008a\u008e\u0002"}, d2={"Lcom/gymchina/library/common/utils/DeviceUtil$Companion;", "", "()V", "getSid", "", "ctx", "Landroid/content/Context;", "getUniqueSid", "isPhone", "", "isTablet", "library_release", "sid"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty0((MutablePropertyReference0)new MutablePropertyReference0Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "sid", "<v#0>"))};
        }

        public final boolean isPhone(@NotNull Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Object object = ctx.getSystemService("phone");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ctx.getSystemService(Context.TELEPHONY_SERVICE)");
            return ((TelephonyManager)CastKt.cast(object)).getPhoneType() != 0;
        }

        public final boolean isTablet(@NotNull Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Resources resources = ctx.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"ctx.resources");
            return (resources.getConfiguration().screenLayout & 0xF) >= 3;
        }

        @NotNull
        public final String getSid(@NotNull Context ctx) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            KProperty kProperty = $$delegatedProperties[0];
            Preference<String> sid = new Preference<String>("device_sid", "", ctx, null, 8, null);
            CharSequence charSequence = (CharSequence)sid.getValue(null, kProperty);
            if (charSequence.length() == 0) {
                sid.setValue(null, kProperty, this.getUniqueSid());
            }
            return (String)sid.getValue(null, kProperty);
        }

        private final String getUniqueSid() {
            String devIdShort = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10;
            String serial = Build.class.getField("SERIAL").get(null).toString();
            String string = new UUID(devIdShort.hashCode(), serial.hashCode()).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID(devIdShort.hashCode\u2026de().toLong()).toString()");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

