/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.mobilepay.wxpay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.gymchina.android.mobilepay.core.PayPlatform;
import com.gymchina.android.mobilepay.core.PayResult;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/gymchina/android/mobilepay/wxpay/AbsWXPayEntryActivity;", "Landroid/app/Activity;", "Lcom/tencent/mm/opensdk/openapi/IWXAPIEventHandler;", "()V", "api", "Lcom/tencent/mm/opensdk/openapi/IWXAPI;", "createWxAPI", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onNewIntent", "intent", "Landroid/content/Intent;", "onReq", "req", "Lcom/tencent/mm/opensdk/modelbase/BaseReq;", "onResp", "resp", "Lcom/tencent/mm/opensdk/modelbase/BaseResp;", "MobilePayment_release"})
public abstract class AbsWXPayEntryActivity
extends Activity
implements IWXAPIEventHandler {
    private IWXAPI api;

    @NotNull
    public abstract IWXAPI createWxAPI();

    public void onCreate(@NotNull Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)savedInstanceState, (String)"savedInstanceState");
        super.onCreate(savedInstanceState);
        IWXAPI iWXAPI = this.api = this.createWxAPI();
        if (iWXAPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"api");
        }
        iWXAPI.handleIntent(this.getIntent(), (IWXAPIEventHandler)this);
    }

    protected void onNewIntent(@NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        super.onNewIntent(intent);
        this.setIntent(intent);
        IWXAPI iWXAPI = this.api;
        if (iWXAPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"api");
        }
        iWXAPI.handleIntent(intent, (IWXAPIEventHandler)this);
    }

    public void onReq(@NotNull BaseReq req) {
        Intrinsics.checkParameterIsNotNull((Object)req, (String)"req");
    }

    public void onResp(@NotNull BaseResp resp) {
        Intrinsics.checkParameterIsNotNull((Object)resp, (String)"resp");
        Log.d((String)"mobile pay", (String)("wxpay onPayFinish, errCode = " + resp.errCode));
        if (resp.getType() == 5) {
            Intent intent = new Intent("action_wechat_pay_resp");
            intent.setPackage(this.getPackageName());
            intent.putExtra("extra_mobile_pay_platform", (Serializable)((Object)PayPlatform.WxPay));
            switch (resp.errCode) {
                case 0: {
                    intent.putExtra("action_wechat_pay_resp", (Serializable)((Object)PayResult.SUCCESS));
                    break;
                }
                case -2: {
                    intent.putExtra("action_wechat_pay_resp", (Serializable)((Object)PayResult.CANCEL));
                    break;
                }
                default: {
                    intent.putExtra("action_wechat_pay_resp", (Serializable)((Object)PayResult.FAIL));
                }
            }
            LocalBroadcastManager.getInstance((Context)((Context)this)).sendBroadcast(intent);
        }
        this.finish();
    }
}

