/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.getuipush;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import com.gymchina.getuipush.entity.CommonPushMessage;
import com.gymchina.getuipush.notification.CommonNotification;
import com.gymchina.jsontool.JsonKt;
import com.gymchina.library.common.utils.Preference;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0015J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0015J\u001f\u0010\f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u000fJ\u001f\u0010\u0010\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u0012J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000eH\u0014\u00a8\u0006\u0014\u00b2\u0006\n\u0010\u0015\u001a\u00020\u000eX\u008a\u008e\u0002"}, d2={"Lcom/gymchina/getuipush/IBridge;", "", "()V", "canShowNotification", "", "createNotificationChannels", "", "ctx", "Landroid/content/Context;", "getNotificationChannels", "", "Landroid/app/NotificationChannel;", "onReceiveClientId", "cId", "", "onReceiveClientId$GetuiPush_release", "onReceiveMessageData", "message", "onReceiveMessageData$GetuiPush_release", "showNotification", "GetuiPush_release", "clientId"})
public abstract class IBridge {
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty0((MutablePropertyReference0)new MutablePropertyReference0Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(IBridge.class), "clientId", "<v#0>"))};
    }

    public void onReceiveMessageData$GetuiPush_release(@Nullable Context ctx, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (ctx == null || StringsKt.isBlank((CharSequence)message)) {
            return;
        }
        if (!this.canShowNotification()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            this.createNotificationChannels(ctx);
        }
        this.showNotification(ctx, message);
    }

    public void onReceiveClientId$GetuiPush_release(@Nullable Context ctx, @NotNull String cId) {
        Intrinsics.checkParameterIsNotNull((Object)cId, (String)"cId");
        if (StringsKt.isBlank((CharSequence)cId)) {
            return;
        }
        KProperty kProperty = $$delegatedProperties[0];
        Preference clientId = new Preference("sp_getui_push_cid", (Object)"", null, null, 12, null);
        clientId.setValue(null, kProperty, (Object)cId);
    }

    protected boolean canShowNotification() {
        return true;
    }

    @TargetApi(value=26)
    protected void createNotificationChannels(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Object object = ctx.getSystemService("notification");
        if (object == null) {
            return;
        }
        Object service = object;
        if (!(service instanceof NotificationManager)) {
            return;
        }
        Collection collection = ((NotificationManager)service).getNotificationChannels();
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            List<NotificationChannel> channels = this.getNotificationChannels();
            Collection collection2 = channels;
            bl2 = false;
            if (!collection2.isEmpty()) {
                ((NotificationManager)service).createNotificationChannels(channels);
            }
        }
    }

    @TargetApi(value=26)
    @NotNull
    protected List<NotificationChannel> getNotificationChannels() {
        return CollectionsKt.listOf((Object)CommonNotification.Companion.getNotificationChannel());
    }

    protected void showNotification(@NotNull Context ctx, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        CommonPushMessage commonPushMessage = (CommonPushMessage)JsonKt.getGSON().fromJson(message, CommonPushMessage.class);
        if (commonPushMessage == null) {
            return;
        }
        CommonPushMessage pushMessage = commonPushMessage;
        new CommonNotification(ctx, pushMessage, null, 4, null).show();
    }
}

