/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.persistence.tools.eclipselink;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class PersistenceXmlHelper {
    public static final String JAVA_EE6_PERSISTENCE_NS = "http://java.sun.com/xml/ns/persistence";
    public static final String JAVA_EE7_PERSISTENCE_NS = "http://xmlns.jcp.org/xml/ns/persistence";
    private static final XPathFactory factory = XPathFactory.newInstance();

    public static Document createXml(String name) {
        try {
            InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("empty-persistence.xml");
            Document doc = PersistenceXmlHelper.getBuilder().parse(input);
            Element puElement = (Element)doc.getElementsByTagName("persistence-unit").item(0);
            puElement.setAttribute("name", name);
            return doc;
        }
        catch (IOException | ParserConfigurationException | SAXException exc) {
            throw new RuntimeException(exc.getMessage(), exc);
        }
    }

    public static void appendClasses(Document doc, Set<String> entityClasses) {
        String nsUri = doc.getDocumentElement().getNamespaceURI();
        Assert.isNotNull((Object)nsUri, (String)"Root element <persistence> should be defined");
        boolean isJavaEE6 = nsUri.equals(JAVA_EE6_PERSISTENCE_NS);
        boolean isJavaEE7 = nsUri.equals(JAVA_EE7_PERSISTENCE_NS);
        Assert.isTrue((isJavaEE6 || isJavaEE7 ? 1 : 0) != 0, (String)"Root <persistence> element should be either http://java.sun.com/xml/ns/persistence or http://xmlns.jcp.org/xml/ns/persistence");
        String targetNs = isJavaEE6 ? JAVA_EE6_PERSISTENCE_NS : JAVA_EE7_PERSISTENCE_NS;
        NodeList persistenceUnits = doc.getDocumentElement().getElementsByTagNameNS(targetNs, "persistence-unit");
        Assert.isNotNull((Object)persistenceUnits, (String)"Could not find a <persistence-unit> element");
        for (int i = 0; i < persistenceUnits.getLength(); ++i) {
            Node persistenceUnit = persistenceUnits.item(i);
            for (String entity : entityClasses) {
                Element element = doc.createElementNS(targetNs, "class");
                element.setTextContent(entity);
                persistenceUnit.appendChild(element);
            }
        }
    }

    public static Document parseXml(File targetFile) {
        try {
            return PersistenceXmlHelper.getBuilder().parse(targetFile);
        }
        catch (IOException | ParserConfigurationException | SAXException exc) {
            throw new RuntimeException(exc.getMessage(), exc);
        }
    }

    public static Set<String> getClassesAlreadyDefined(Document doc) {
        final String ns = doc.getDocumentElement().getNamespaceURI();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if ("ns".equals(prefix)) {
                    return ns;
                }
                return "";
            }

            @Override
            public String getPrefix(String uri) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<String> getPrefixes(String uri) {
                throw new UnsupportedOperationException();
            }
        });
        try {
            XPathExpression expr = xpath.compile("/ns:persistence/ns:persistence-unit/ns:class");
            NodeList res = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            TreeSet<String> existing = new TreeSet<String>();
            for (int i = 0; i < res.getLength(); ++i) {
                String existingClassName = res.item(i).getTextContent();
                existing.add(existingClassName);
            }
            return existing;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static DocumentBuilder getBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        return dbFactory.newDocumentBuilder();
    }

    public static void outputXml(Document doc, File targetFile) {
        if (!targetFile.exists()) {
            targetFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(targetFile);){
            PersistenceXmlHelper.prettyPrint(doc, writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void prettyPrint(Document document, Writer writer) {
        DOMImplementation domImplementation = document.getImplementation();
        DOMImplementationLS domImplementationLS = (DOMImplementationLS)domImplementation.getFeature("LS", "3.0");
        LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
        lsSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        LSOutput lsOutput = domImplementationLS.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        lsOutput.setCharacterStream(writer);
        lsSerializer.write(document, lsOutput);
    }
}

