/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins.tenancy.handler;

import com.baomidou.mybatisplus.plugins.tenancy.handler.TenancyHandler;
import com.baomidou.mybatisplus.toolkit.PluginUtils;
import java.util.Properties;
import java.util.regex.Pattern;

public class RegxTenancyHandler
implements TenancyHandler {
    private boolean filterDefault = false;
    private Pattern[] tablePatterns;
    private Pattern[] statementPatterns;

    @Override
    public void setConfig(Properties properties) {
        this.setFilterStatementRegexStr(PluginUtils.getProperty(properties, "filterStatementRegexStr"));
        this.setFilterTableRegexStr(PluginUtils.getProperty(properties, "filterTableRegexStr"));
        String filterDefault = PluginUtils.getProperty(properties, "filterDefault");
        if (filterDefault != null) {
            this.setFilterDefault(Boolean.valueOf(filterDefault));
        }
    }

    @Override
    public boolean doTable(String table) {
        boolean isOk = this.filterDefault;
        if (this.tablePatterns != null) {
            for (Pattern p : this.tablePatterns) {
                if (!p.matcher(table).find()) continue;
                isOk = !this.filterDefault;
                break;
            }
        }
        return isOk;
    }

    @Override
    public boolean doStatement(String statementId) {
        boolean isOk = this.filterDefault;
        if (this.statementPatterns != null) {
            for (Pattern p : this.statementPatterns) {
                if (!p.matcher(statementId).find()) continue;
                isOk = !this.filterDefault;
                break;
            }
        }
        return isOk;
    }

    public static Pattern[] compile(String patterString) {
        if (patterString == null) {
            return new Pattern[0];
        }
        String[] patterStrings = patterString.split(",");
        return RegxTenancyHandler.compile(patterStrings);
    }

    public static Pattern[] compile(String[] patterStrings) {
        if (patterStrings == null) {
            return new Pattern[0];
        }
        Pattern[] patterns = new Pattern[patterStrings.length];
        for (int i = 0; i < patterStrings.length; ++i) {
            Pattern pattern;
            patterns[i] = pattern = Pattern.compile(patterStrings[i]);
        }
        return patterns;
    }

    public RegxTenancyHandler setFilterTableRegexStr(String tableRegexStr) {
        if (tableRegexStr == null) {
            return this;
        }
        this.tablePatterns = RegxTenancyHandler.compile(tableRegexStr);
        return this;
    }

    public RegxTenancyHandler setFilterTableRegexArr(String[] tableRegexArr) {
        if (tableRegexArr == null) {
            return this;
        }
        this.tablePatterns = RegxTenancyHandler.compile(tableRegexArr);
        return this;
    }

    public RegxTenancyHandler setFilterStatementRegexStr(String statementRegexStr) {
        if (statementRegexStr == null) {
            return this;
        }
        this.statementPatterns = RegxTenancyHandler.compile(statementRegexStr);
        return this;
    }

    public RegxTenancyHandler setFilterStatementRegexArr(String[] statementRegexArr) {
        if (statementRegexArr == null) {
            return this;
        }
        this.statementPatterns = RegxTenancyHandler.compile(statementRegexArr);
        return this;
    }

    public RegxTenancyHandler setFilterDefault(boolean filterDefault) {
        this.filterDefault = filterDefault;
        return this;
    }
}

