/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins.tenancy;

import com.baomidou.mybatisplus.parser.AbstractSqlParser;
import com.baomidou.mybatisplus.parser.SqlInfo;
import com.baomidou.mybatisplus.plugins.tenancy.TenantInfo;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;

public class TenancySqlParser
extends AbstractSqlParser {
    private TenantInfo tenantInfo;

    @Override
    public SqlInfo optimizeSql(String sql) {
        Statement stmt = null;
        try {
            stmt = CCJSqlParserUtil.parse((String)sql);
        }
        catch (JSQLParserException e) {
            return null;
        }
        if (stmt instanceof Insert) {
            this.processInsert((Insert)stmt);
        } else if (stmt instanceof Select) {
            this.processSelectBody(((Select)stmt).getSelectBody());
        } else if (stmt instanceof Update) {
            this.processUpdate((Update)stmt);
        }
        SqlInfo sqlInfo = SqlInfo.newInstance();
        sqlInfo.setSql(stmt.toString());
        return sqlInfo;
    }

    public void processSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSelectBody() != null) {
                this.processSelectBody(withItem.getSelectBody());
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                List plainSelects = operationList.getSelects();
                for (SelectBody plainSelect : plainSelects) {
                    this.processSelectBody(plainSelect);
                }
            }
        }
    }

    public void processInsert(Insert insert) {
        if (this.doTableFilter(insert.getTable().getName())) {
            insert.getColumns().add(new Column(this.tenantInfo.getTenantIdColumn()));
            if (insert.getSelect() != null) {
                this.processPlainSelect((PlainSelect)insert.getSelect().getSelectBody(), true);
            } else if (insert.getItemsList() != null) {
                ((ExpressionList)insert.getItemsList()).getExpressions().add(new StringValue("," + this.tenantInfo.getTenantId() + ","));
            } else {
                throw new RuntimeException("\u65e0\u6cd5\u5904\u7406\u7684 sql");
            }
        }
    }

    public void processUpdate(Update update) {
        Expression where = update.getWhere();
        EqualsTo equalsTo = new EqualsTo();
        if (where instanceof BinaryExpression) {
            equalsTo.setLeftExpression((Expression)new Column(this.tenantInfo.getTenantIdColumn()));
            equalsTo.setRightExpression((Expression)new StringValue("," + this.tenantInfo.getTenantId() + ","));
            AndExpression andExpression = new AndExpression((Expression)equalsTo, where);
            update.setWhere((Expression)andExpression);
        } else {
            equalsTo.setLeftExpression((Expression)new Column(this.tenantInfo.getTenantIdColumn()));
            equalsTo.setRightExpression((Expression)new StringValue("," + this.tenantInfo.getTenantId() + ","));
            update.setWhere((Expression)equalsTo);
        }
    }

    public void processDelete(Delete delete) {
    }

    public void processPlainSelect(PlainSelect plainSelect) {
        this.processPlainSelect(plainSelect, false);
    }

    public void processPlainSelect(PlainSelect plainSelect, boolean addColumn) {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            if (this.doTableFilter(fromTable.getName())) {
                plainSelect.setWhere(this.builderExpression(plainSelect.getWhere(), fromTable));
                if (addColumn) {
                    plainSelect.getSelectItems().add(new SelectExpressionItem((Expression)new Column("'" + this.tenantInfo.getTenantId() + "'")));
                }
            }
        } else {
            this.processFromItem(fromItem);
        }
        List joins = plainSelect.getJoins();
        if (joins != null && joins.size() > 0) {
            for (Join join : joins) {
                this.processJoin(join);
                this.processFromItem(join.getRightItem());
            }
        }
    }

    public void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoin() != null) {
                this.processJoin(subJoin.getJoin());
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (!(fromItem instanceof ValuesList) && fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    public void processJoin(Join join) {
        Table fromTable;
        if (join.getRightItem() instanceof Table && this.doTableFilter((fromTable = (Table)join.getRightItem()).getName())) {
            join.setOnExpression(this.builderExpression(join.getOnExpression(), fromTable));
        }
    }

    public Expression builderExpression(Expression expression, Table table) {
        EqualsTo tenantExpression = null;
        String[] tenantIds = this.tenantInfo.getTenantId().split(",");
        StringBuilder tenantIdColumnName = new StringBuilder();
        if (table != null) {
            tenantIdColumnName.append(table.getAlias() != null ? table.getAlias().getName() : table.getName());
            tenantIdColumnName.append(".");
        }
        tenantIdColumnName.append(this.tenantInfo.getTenantIdColumn());
        Column tenantColumn = new Column(tenantIdColumnName.toString());
        if (tenantIds.length == 1) {
            EqualsTo equalsTo;
            tenantExpression = equalsTo = new EqualsTo();
            equalsTo.setLeftExpression((Expression)tenantColumn);
            equalsTo.setRightExpression((Expression)new StringValue("'" + tenantIds[0] + "'"));
        } else {
            InExpression inExpression = new InExpression();
            tenantExpression = inExpression;
            inExpression.setLeftExpression((Expression)tenantColumn);
            ArrayList<StringValue> valueList = new ArrayList<StringValue>();
            for (String tid : tenantIds) {
                valueList.add(new StringValue("'" + tid + "'"));
            }
            inExpression.setRightItemsList((ItemsList)new ExpressionList(valueList));
        }
        if (expression == null) {
            return tenantExpression;
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            if (binaryExpression.getLeftExpression() instanceof FromItem) {
                this.processFromItem((FromItem)binaryExpression.getLeftExpression());
            }
            if (binaryExpression.getRightExpression() instanceof FromItem) {
                this.processFromItem((FromItem)binaryExpression.getRightExpression());
            }
        }
        return new AndExpression((Expression)tenantExpression, expression);
    }

    private boolean doTableFilter(String table) {
        return true;
    }
}

