/*
 * Decompiled with CFR 0.152.
 */
package com.android.gymchina.framework.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.support.annotation.ArrayRes;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.util.TypedValue;
import com.android.gymchina.framework.base.Application;

public final class ResUtil {
    private ResUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static Resources getResource() {
        return Application.instance().getResources();
    }

    public static String getString(@StringRes int resId) {
        return ResUtil.getResource().getString(resId);
    }

    public static String getString(@StringRes int id, Object ... formatArgs) {
        return ResUtil.getResource().getString(id, formatArgs);
    }

    public static String[] getStringArr(@ArrayRes int resId) {
        return ResUtil.getResource().getStringArray(resId);
    }

    public static int getColor(@ColorRes int colorId) {
        return ResUtil.getResource().getColor(colorId);
    }

    public static float getDimension(@DimenRes int dimenId) {
        return ResUtil.getResource().getDimension(dimenId);
    }

    public static int getDimensionPixelSize(@DimenRes int dimenId) {
        return ResUtil.getResource().getDimensionPixelSize(dimenId);
    }

    public static int getDimensionPixelOffset(@DimenRes int dimenId) {
        return ResUtil.getResource().getDimensionPixelOffset(dimenId);
    }

    public static float getCustomFloat(@DimenRes int dimenId) {
        TypedValue outValue = new TypedValue();
        ResUtil.getResource().getValue(dimenId, outValue, true);
        return outValue.getFloat();
    }

    public static Bitmap decodeResource(@DrawableRes int drawableRes) {
        return BitmapFactory.decodeResource((Resources)ResUtil.getResource(), (int)drawableRes);
    }

    public static Drawable getDrawable(@DrawableRes int drawableRes) {
        return ResUtil.getResource().getDrawable(drawableRes);
    }
}

