/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.model.GetSubscriptionOffsetRequest;
import com.aliyun.datahub.model.GetSubscriptionOffsetResult;
import com.aliyun.datahub.model.Offset;
import com.aliyun.datahub.model.serialize.Deserializer;
import com.aliyun.datahub.model.serialize.JsonErrorParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class GetSubscriptionOffsetResultJsonDeser
implements Deserializer<GetSubscriptionOffsetResult, GetSubscriptionOffsetRequest, Response> {
    private static GetSubscriptionOffsetResultJsonDeser instance;

    @Override
    public GetSubscriptionOffsetResult deserialize(GetSubscriptionOffsetRequest request, Response response) throws DatahubServiceException {
        if (!response.isOK()) {
            throw JsonErrorParser.getInstance().parse(response);
        }
        GetSubscriptionOffsetResult rs = new GetSubscriptionOffsetResult();
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        JsonNode tree = null;
        try {
            tree = mapper.readTree(response.getBody());
        }
        catch (IOException e) {
            throw new DatahubServiceException("JsonParseError", "Parse body failed:" + response.getBody(), response);
        }
        JsonNode offsetsNode = tree.get("Offsets");
        if (!offsetsNode.isObject()) {
            throw new DatahubServiceException("JsonParseError", "invalid offsets node value", response);
        }
        HashMap<String, Offset> offsets = new HashMap<String, Offset>();
        Iterator iterator = offsetsNode.getFields();
        while (iterator.hasNext()) {
            Map.Entry offsetNode = (Map.Entry)iterator.next();
            Offset offset = new Offset(((JsonNode)offsetNode.getValue()).get("Sequence").asLong(), ((JsonNode)offsetNode.getValue()).get("Timestamp").asLong());
            offsets.put((String)offsetNode.getKey(), offset);
        }
        rs.setOffsets(offsets);
        return rs;
    }

    private GetSubscriptionOffsetResultJsonDeser() {
    }

    public static GetSubscriptionOffsetResultJsonDeser getInstance() {
        if (instance == null) {
            instance = new GetSubscriptionOffsetResultJsonDeser();
        }
        return instance;
    }
}

