/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.HttpMethod;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.CreateConnectorRequest;
import com.aliyun.datahub.model.serialize.Serializer;
import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

@Deprecated
public class CreateConnectorRequestJsonSer
implements Serializer<DefaultRequest, CreateConnectorRequest> {
    private static CreateConnectorRequestJsonSer instance;

    @Override
    public DefaultRequest serialize(CreateConnectorRequest request) throws DatahubClientException {
        DefaultRequest req = new DefaultRequest();
        req.setResource("/projects/" + request.getProjectName() + "/topics/" + request.getTopicName() + "/connectors/" + request.getType().toString().toLowerCase());
        req.setHttpMethod(HttpMethod.POST);
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        ArrayNode columnFields = mapper.createArrayNode();
        for (String i : request.getColumnFields()) {
            columnFields.add(i);
        }
        node.put("ColumnFields", (JsonNode)columnFields);
        node.put("Action", "create");
        ObjectNode odpsDesc = mapper.createObjectNode();
        odpsDesc.put("Project", request.getOdpsDesc().getProject());
        odpsDesc.put("Table", request.getOdpsDesc().getTable());
        odpsDesc.put("OdpsEndpoint", request.getOdpsDesc().getOdpsEndpoint());
        if (request.getOdpsDesc().getTunnelEndpoint() != null) {
            odpsDesc.put("TunnelEndpoint", request.getOdpsDesc().getTunnelEndpoint());
        }
        odpsDesc.put("AccessId", request.getOdpsDesc().getAccessId());
        odpsDesc.put("AccessKey", request.getOdpsDesc().getAccessKey());
        node.put("Config", (JsonNode)odpsDesc);
        try {
            req.setBody(mapper.writeValueAsString((Object)node));
        }
        catch (IOException e) {
            throw new DatahubClientException("serialize error", e);
        }
        return req;
    }

    private CreateConnectorRequestJsonSer() {
    }

    public static CreateConnectorRequestJsonSer getInstance() {
        if (instance == null) {
            instance = new CreateConnectorRequestJsonSer();
        }
        return instance;
    }
}

