/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model;

import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.AuthMode;
import com.aliyun.datahub.model.ConnectorConfig;
import com.aliyun.datahub.model.OffsetStoreType;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class OtsDesc
extends ConnectorConfig {
    private String endpoint;
    private String instance;
    private String table;
    private AuthMode authMode;
    private String accessId;
    private String accessKey;
    private OffsetStoreType offsetStoreType;

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public AuthMode getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(AuthMode authMode) {
        this.authMode = authMode;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public OffsetStoreType getOffsetStoreType() {
        return this.offsetStoreType;
    }

    public void setOffsetStoreType(OffsetStoreType offsetStoreType) {
        this.offsetStoreType = offsetStoreType;
    }

    @Override
    public ObjectNode toJsonNode() {
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ObjectNode otsDesc = mapper.createObjectNode();
        otsDesc.put("Endpoint", this.endpoint);
        otsDesc.put("InstanceName", this.instance);
        otsDesc.put("TableName", this.table);
        if (AuthMode.AK == this.authMode) {
            otsDesc.put("AuthMode", "ak");
            otsDesc.put("AccessId", this.accessId);
            otsDesc.put("AccessKey", this.accessKey);
        } else {
            otsDesc.put("AuthMode", "sts");
        }
        if (OffsetStoreType.COORDINATOR == this.offsetStoreType) {
            otsDesc.put("OffsetStoreType", "coordinator");
        } else {
            otsDesc.put("OffsetStoreType", "mysql");
        }
        return otsDesc;
    }

    @Override
    public void ParseFromJsonNode(JsonNode node) {
        if (node != null && !node.isNull()) {
            JsonNode sub = node.get("Endpoint");
            if (sub != null && !sub.isNull()) {
                this.endpoint = sub.asText();
            }
            if ((sub = node.get("InstanceName")) != null && !sub.isNull()) {
                this.instance = sub.asText();
            }
            if ((sub = node.get("TableName")) != null && !sub.isNull()) {
                this.table = sub.asText();
            }
            if ((sub = node.get("AuthMode")) != null && !sub.isNull()) {
                this.authMode = "ak" == sub.asText() ? AuthMode.AK : AuthMode.STS;
            }
            if ((sub = node.get("AccessId")) != null && !sub.isNull()) {
                this.accessId = sub.asText();
            }
            if ((sub = node.get("AccessKey")) != null && !sub.isNull()) {
                this.accessKey = sub.asText();
            }
            if ((sub = node.get("OffsetStoreType")) != null && !sub.isNull()) {
                this.offsetStoreType = sub.asText().equals("coordinator") ? OffsetStoreType.COORDINATOR : OffsetStoreType.MYSQL;
            }
        } else {
            throw new DatahubClientException("Invalid response, missing config.");
        }
    }
}

