/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model;

import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.ConnectorConfig;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class DatahubDesc
extends ConnectorConfig {
    private String endpoint;
    private String project;
    private String topic;
    public final String DATAHUB_PROJECT = "Project";
    public final String DATAHUB_TOPIC = "Topic";
    public final String DATAHUB_ENDPOINT = "DatahubEndpoint";

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Override
    public ObjectNode toJsonNode() {
        if (this.endpoint == null || this.endpoint.isEmpty()) {
            throw new DatahubClientException("endpoint is null");
        }
        if (this.project == null || this.project.isEmpty()) {
            throw new DatahubClientException("project is null");
        }
        if (this.topic == null || this.topic.isEmpty()) {
            throw new DatahubClientException("topic is null");
        }
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        rootNode.put("DatahubEndpoint", this.endpoint);
        rootNode.put("Project", this.project);
        rootNode.put("Topic", this.topic);
        return rootNode;
    }

    @Override
    public void ParseFromJsonNode(JsonNode node) {
        if (node != null && !node.isNull()) {
            JsonNode config = node.get("DatahubEndpoint");
            if (config != null && !config.isNull()) {
                this.setEndpoint(config.asText());
            }
            if ((config = node.get("Project")) != null && !config.isNull()) {
                this.setProject(config.asText());
            }
            if ((config = node.get("Topic")) != null && !config.isNull()) {
                this.setTopic(config.asText());
            }
        } else {
            throw new DatahubClientException("Invalid response, missing config.");
        }
    }
}

