/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.example;

import com.aliyun.datahub.DatahubClient;
import com.aliyun.datahub.DatahubConfiguration;
import com.aliyun.datahub.auth.AliyunAccount;
import com.aliyun.datahub.example.Consumer;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.GetTopicResult;
import com.aliyun.datahub.model.ListShardResult;
import java.util.ArrayList;

public class SubscriptionExample {
    private String accessId = "**you access id**";
    private String accessKey = "**you access key**";
    private String endpoint = "**datahub server endpoint**";
    private String projectName = "**you project name**";
    private String topicName = "**you topic name**";
    private String subId = "**you subscription id**";
    private DatahubConfiguration conf = new DatahubConfiguration(new AliyunAccount(this.accessId, this.accessKey), this.endpoint);
    private DatahubClient client = new DatahubClient(this.conf);

    public void Start() {
        GetTopicResult topicResult = this.client.getTopic(this.projectName, this.topicName);
        ListShardResult shardResult = this.client.listShard(this.projectName, this.topicName);
        ArrayList<Consumer> threadList = new ArrayList<Consumer>();
        for (int i = 0; i < shardResult.getShards().size(); ++i) {
            threadList.add(new Consumer(this.projectName, this.topicName, this.subId, shardResult.getShards().get(i).getShardId(), topicResult.getRecordSchema(), this.conf));
            ((Consumer)threadList.get(i)).start();
        }
        for (Thread thread : threadList) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                System.out.println("Thread interrupted!");
            }
        }
    }

    public static void main(String[] args) {
        SubscriptionExample example = new SubscriptionExample();
        try {
            example.Start();
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
        }
    }
}

