/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.example;

import com.aliyun.datahub.DatahubClient;
import com.aliyun.datahub.DatahubConfiguration;
import com.aliyun.datahub.auth.AliyunAccount;
import com.aliyun.datahub.common.data.Field;
import com.aliyun.datahub.common.data.FieldType;
import com.aliyun.datahub.common.data.RecordSchema;
import com.aliyun.datahub.common.data.RecordType;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.exception.InvalidCursorException;
import com.aliyun.datahub.model.AppendDataConnectorFieldRequest;
import com.aliyun.datahub.model.AppendFieldRequest;
import com.aliyun.datahub.model.ConnectorType;
import com.aliyun.datahub.model.DatabaseDesc;
import com.aliyun.datahub.model.ElasticSearchDesc;
import com.aliyun.datahub.model.GetCursorRequest;
import com.aliyun.datahub.model.GetCursorResult;
import com.aliyun.datahub.model.GetDataConnectorShardStatusResult;
import com.aliyun.datahub.model.GetRecordsResult;
import com.aliyun.datahub.model.GetTopicResult;
import com.aliyun.datahub.model.ListShardResult;
import com.aliyun.datahub.model.OdpsDesc;
import com.aliyun.datahub.model.PutRecordsResult;
import com.aliyun.datahub.model.RecordEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DatahubExample {
    private String accessId = "";
    private String accessKey = "=";
    private String endpoint = "http://";
    private String projectName = "test_project";
    private String topicName = "topic_test_example";
    private RecordSchema schema = null;
    private DatahubConfiguration conf = new DatahubConfiguration(new AliyunAccount(this.accessId, this.accessKey), this.endpoint);
    private DatahubClient client = new DatahubClient(this.conf);

    public void init() {
        this.schema = new RecordSchema();
        this.schema.addField(new Field("f1", FieldType.STRING));
        this.client.createTopic(this.projectName, this.topicName, 3, 3, RecordType.TUPLE, this.schema, "topic");
        GetTopicResult topic = this.client.getTopic(this.projectName, this.topicName);
        this.schema = topic.getRecordSchema();
    }

    public void putRecords() {
        ListShardResult shards = this.client.listShard(this.projectName, this.topicName);
        ArrayList<RecordEntry> recordEntries = new ArrayList<RecordEntry>();
        int recordNum = 10;
        for (int n = 0; n < recordNum; ++n) {
            RecordEntry entry = new RecordEntry(this.schema);
            for (int i = 0; i < entry.getFieldCount(); ++i) {
                entry.setString(i, "test");
            }
            String shardId = shards.getShards().get(0).getShardId();
            entry.setShardId(shardId);
            recordEntries.add(entry);
        }
        PutRecordsResult result = this.client.putRecords(this.projectName, this.topicName, recordEntries);
    }

    public void getRecords() {
        ListShardResult shards = this.client.listShard(this.projectName, this.topicName);
        String shardId = shards.getShards().get(0).getShardId();
        GetCursorResult cursorRs = this.client.getCursor(this.projectName, this.topicName, shardId, System.currentTimeMillis() - 86400000L);
        String cursor = cursorRs.getCursor();
        int limit = 10;
        while (true) {
            try {
                while (true) {
                    GetRecordsResult recordRs = this.client.getRecords(this.projectName, this.topicName, shardId, cursor, limit, this.schema);
                    List<RecordEntry> recordEntries = recordRs.getRecords();
                    if (cursor.equals(recordRs.getNextCursor())) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    cursor = recordRs.getNextCursor();
                }
            }
            catch (InvalidCursorException ex) {
                cursorRs = this.client.getCursor(this.projectName, this.topicName, shardId, GetCursorRequest.CursorType.OLDEST);
                cursor = cursorRs.getCursor();
                continue;
            }
            break;
        }
    }

    public void createOdpsDataConnector() {
        String odpsProject = "datahub_test";
        String odpsTable = "test_table";
        String odpsEndpoint = "http://service-all.ext.odps.aliyun-inc.com/api";
        String tunnelEndpoint = "http://dt-all.ext.odps.aliyun-inc.com";
        OdpsDesc odpsDesc = new OdpsDesc();
        odpsDesc.setProject(odpsProject);
        odpsDesc.setTable(odpsTable);
        odpsDesc.setOdpsEndpoint(odpsEndpoint);
        odpsDesc.setTunnelEndpoint(tunnelEndpoint);
        odpsDesc.setAccessId(this.accessId);
        odpsDesc.setAccessKey(this.accessKey);
        odpsDesc.setPartitionMode(OdpsDesc.PartitionMode.USER_DEFINE);
        ArrayList<String> columnFields = new ArrayList<String>();
        columnFields.add("f1");
        int timeRange = 15;
        odpsDesc.setPartitionMode(OdpsDesc.PartitionMode.SYSTEM_TIME);
        odpsDesc.setTimeRange(timeRange);
        HashMap<String, String> partitionConfig = new HashMap<String, String>();
        partitionConfig.put("pt", "%Y%m%d");
        partitionConfig.put("ct", "%H%M");
        odpsDesc.setPartitionConfig(partitionConfig);
        this.client.createDataConnector(this.projectName, this.topicName, ConnectorType.SINK_ODPS, columnFields, odpsDesc);
        String shard = "0";
        GetDataConnectorShardStatusResult getDataConnectorShardStatusResult = this.client.getDataConnectorShardStatus(this.projectName, this.topicName, ConnectorType.SINK_ODPS, shard);
        System.out.println(getDataConnectorShardStatusResult.getCurSequence());
        System.out.println(getDataConnectorShardStatusResult.getLastErrorMessage());
    }

    public void createADSDataConnector() {
        String dbHost = "127.0.0.1";
        int dbPort = 3306;
        String dbName = "db";
        String user = "123";
        String password = "123";
        String tableName = "table";
        DatabaseDesc desc = new DatabaseDesc();
        desc.setHost(dbHost);
        desc.setPort(dbPort);
        desc.setDatabase(dbName);
        desc.setUser(user);
        desc.setPassword(password);
        desc.setTable(tableName);
        desc.setMaxCommitSize(512L);
        desc.setIgnore(true);
        ArrayList<String> columnFields = new ArrayList<String>();
        columnFields.add("f1");
        this.client.createDataConnector(this.projectName, this.topicName, ConnectorType.SINK_ADS, columnFields, desc);
        String shard = "0";
        GetDataConnectorShardStatusResult getDataConnectorShardStatusResult = this.client.getDataConnectorShardStatus(this.projectName, this.topicName, ConnectorType.SINK_ADS, shard);
        System.out.println(getDataConnectorShardStatusResult.getCurSequence());
        System.out.println(getDataConnectorShardStatusResult.getLastErrorMessage());
    }

    public void createESDataConnector() {
        String dbHost = "127.0.0.1";
        String index = "index";
        String user = "123";
        String password = "123";
        String tableName = "table";
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("f1");
        ArrayList<String> types = new ArrayList<String>();
        types.add("f1");
        ElasticSearchDesc desc = new ElasticSearchDesc();
        desc.setEndpoint(dbHost);
        desc.setIndex(index);
        desc.setUser(user);
        desc.setPassword(password);
        desc.setIdFields(ids);
        desc.setTypeFields(types);
        desc.setMaxCommitSize(512L);
        desc.setProxyMode(true);
        ArrayList<String> columnFields = new ArrayList<String>();
        columnFields.add("f1");
        this.client.createDataConnector(this.projectName, this.topicName, ConnectorType.SINK_ES, columnFields, desc);
        String shard = "0";
        GetDataConnectorShardStatusResult getDataConnectorShardStatusResult = this.client.getDataConnectorShardStatus(this.projectName, this.topicName, ConnectorType.SINK_ADS, shard);
        System.out.println(getDataConnectorShardStatusResult.getCurSequence());
        System.out.println(getDataConnectorShardStatusResult.getLastErrorMessage());
    }

    public void appendField() {
        this.client.appendField(new AppendFieldRequest(this.projectName, this.topicName, new Field("fieldName", FieldType.STRING)));
        this.client.appendDataConnectorField(new AppendDataConnectorFieldRequest(this.projectName, this.topicName, ConnectorType.SINK_ODPS, "fieldName"));
    }

    public static void main(String[] args) {
        DatahubExample example = new DatahubExample();
        try {
            example.init();
            example.putRecords();
            example.getRecords();
            example.createADSDataConnector();
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
        }
    }
}

