/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.auth;

import com.aliyun.datahub.auth.RequestSigner;
import com.aliyun.datahub.auth.SecurityUtils;
import com.aliyun.datahub.common.transport.DefaultRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;

public class AliyunRequestSigner
implements RequestSigner {
    private static final Logger log = Logger.getLogger(AliyunRequestSigner.class.getName());
    private String accessId;
    private String accessKey;
    private String securityToken;

    public AliyunRequestSigner(String accessId, String accessKey) {
        if (accessId == null || accessId.length() == 0) {
            throw new IllegalArgumentException("AccessId should not be empty.");
        }
        if (accessKey == null || accessKey.length() == 0) {
            throw new IllegalArgumentException("AccessKey should not be empty.");
        }
        this.securityToken = null;
        this.accessId = accessId;
        this.accessKey = accessKey;
    }

    public AliyunRequestSigner(String accessId, String accessKey, String securityToken) {
        if (accessId == null || accessId.length() == 0) {
            throw new IllegalArgumentException("AccessId should not be empty.");
        }
        if (accessKey == null || accessKey.length() == 0) {
            throw new IllegalArgumentException("AccessKey should not be empty.");
        }
        this.securityToken = securityToken;
        this.accessId = accessId;
        this.accessKey = accessKey;
    }

    @Override
    public void sign(String resource, DefaultRequest req) {
        if (this.securityToken != null && !this.securityToken.isEmpty()) {
            req.getHeaders().put("x-datahub-security-token", this.securityToken);
        }
        req.getHeaders().put("Authorization", this.getSignature(resource, req));
    }

    public String getSignature(String resource, DefaultRequest req) {
        try {
            resource = URLDecoder.decode(resource, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        String strToSign = SecurityUtils.buildCanonicalString(resource, req, "x-datahub-");
        if (log.isLoggable(Level.FINE)) {
            log.fine("String to sign: " + strToSign);
        }
        byte[] crypto = SecurityUtils.hmacsha1Signature(strToSign.getBytes(), this.accessKey.getBytes());
        String signature = Base64.encodeBase64String((byte[])crypto).trim();
        return "DATAHUB " + this.accessId + ":" + signature;
    }
}

