/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.ribbon;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.ribbon.ExtendBalancer;
import com.alibaba.cloud.nacos.ribbon.NacosServer;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import com.netflix.loadbalancer.DynamicServerListLoadBalancer;
import com.netflix.loadbalancer.Server;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class NacosRule
extends AbstractLoadBalancerRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosRule.class);
    @Autowired
    private NacosDiscoveryProperties nacosDiscoveryProperties;

    public Server choose(Object key) {
        try {
            String clusterName = this.nacosDiscoveryProperties.getClusterName();
            DynamicServerListLoadBalancer loadBalancer = (DynamicServerListLoadBalancer)this.getLoadBalancer();
            String name = loadBalancer.getName();
            NamingService namingService = this.nacosDiscoveryProperties.namingServiceInstance();
            List instances = namingService.selectInstances(name, true);
            if (CollectionUtils.isEmpty((Collection)instances)) {
                LOGGER.warn("no instance in service {}", (Object)name);
                return null;
            }
            List instancesToChoose = instances;
            if (StringUtils.isNotBlank((CharSequence)clusterName)) {
                List sameClusterInstances = instances.stream().filter(instance -> Objects.equals(clusterName, instance.getClusterName())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(sameClusterInstances)) {
                    instancesToChoose = sameClusterInstances;
                } else {
                    LOGGER.warn("A cross-cluster call occurs\uff0cname = {}, clusterName = {}, instance = {}", new Object[]{name, clusterName, instances});
                }
            }
            Instance instance2 = ExtendBalancer.getHostByRandomWeight2(instancesToChoose);
            return new NacosServer(instance2);
        }
        catch (Exception e) {
            LOGGER.warn("NacosRule error", (Throwable)e);
            return null;
        }
    }

    public void initWithNiwsConfig(IClientConfig iClientConfig) {
    }
}

