//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.response;

import cn.com.antcloud.api.bccr.v1_0_0.model.SecurityData;
import cn.com.antcloud.api.product.AntCloudProdResponse;
import java.lang.Long;
import java.lang.String;

/**
 * 版权平台查询版权登记状态 */
public class QueryRegisterstatusResponse extends AntCloudProdResponse {
  private String status;

  private Long timestamp;

  private String hash;

  private String txHash;

  private Long blockHeight;

  private String tsr;

  private String certificateUrl;

  private String certificateStorageNo;

  private String certificateTimeUrl;

  private String packageUrl;

  private String statementUrl;

  private String statementTxHash;

  private String registerPersonTxHash;

  private SecurityData security;

  /**
   * 登记状态 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 登记状态 */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * 存证时间 */
  public Long getTimestamp() {
    return this.timestamp;
  }

  /**
   * 存证时间 */
  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }

  /**
   * 文件hash */
  public String getHash() {
    return this.hash;
  }

  /**
   * 文件hash */
  public void setHash(String hash) {
    this.hash = hash;
  }

  /**
   * 统一证据编号（存证交易HASH） */
  public String getTxHash() {
    return this.txHash;
  }

  /**
   * 统一证据编号（存证交易HASH） */
  public void setTxHash(String txHash) {
    this.txHash = txHash;
  }

  /**
   * 存证块高 */
  public Long getBlockHeight() {
    return this.blockHeight;
  }

  /**
   * 存证块高 */
  public void setBlockHeight(Long blockHeight) {
    this.blockHeight = blockHeight;
  }

  /**
   * tsr信息 */
  public String getTsr() {
    return this.tsr;
  }

  /**
   * tsr信息 */
  public void setTsr(String tsr) {
    this.tsr = tsr;
  }

  /**
   * 公证处证书下载链接 */
  public String getCertificateUrl() {
    return this.certificateUrl;
  }

  /**
   * 公证处证书下载链接 */
  public void setCertificateUrl(String certificateUrl) {
    this.certificateUrl = certificateUrl;
  }

  /**
   * 公证处证书编号 */
  public String getCertificateStorageNo() {
    return this.certificateStorageNo;
  }

  /**
   * 公证处证书编号 */
  public void setCertificateStorageNo(String certificateStorageNo) {
    this.certificateStorageNo = certificateStorageNo;
  }

  /**
   * 授时中心证书下载链接 */
  public String getCertificateTimeUrl() {
    return this.certificateTimeUrl;
  }

  /**
   * 授时中心证书下载链接 */
  public void setCertificateTimeUrl(String certificateTimeUrl) {
    this.certificateTimeUrl = certificateTimeUrl;
  }

  /**
   * 证据包下载地址（状态为SUCCESS并且请求要求生成证据包才有数据） */
  public String getPackageUrl() {
    return this.packageUrl;
  }

  /**
   * 证据包下载地址（状态为SUCCESS并且请求要求生成证据包才有数据） */
  public void setPackageUrl(String packageUrl) {
    this.packageUrl = packageUrl;
  }

  /**
   * 权利声明书下载地址 注意只有传递了权利信息并且生成了权利声明书才会返回 */
  public String getStatementUrl() {
    return this.statementUrl;
  }

  /**
   * 权利声明书下载地址 注意只有传递了权利信息并且生成了权利声明书才会返回 */
  public void setStatementUrl(String statementUrl) {
    this.statementUrl = statementUrl;
  }

  /**
   * 权利声明书存证交易HASH  注意只有传递了权利信息并且生成了权利声明书才会返回 */
  public String getStatementTxHash() {
    return this.statementTxHash;
  }

  /**
   * 权利声明书存证交易HASH  注意只有传递了权利信息并且生成了权利声明书才会返回 */
  public void setStatementTxHash(String statementTxHash) {
    this.statementTxHash = statementTxHash;
  }

  /**
   * 登记人信息存证交易HASH */
  public String getRegisterPersonTxHash() {
    return this.registerPersonTxHash;
  }

  /**
   * 登记人信息存证交易HASH */
  public void setRegisterPersonTxHash(String registerPersonTxHash) {
    this.registerPersonTxHash = registerPersonTxHash;
  }

  /**
   * 安全信息 */
  public SecurityData getSecurity() {
    return this.security;
  }

  /**
   * 安全信息 */
  public void setSecurity(SecurityData security) {
    this.security = security;
  }
}
