//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.request;

import cn.com.antcloud.api.bccr.v1_0_0.model.VerifyEvidenceData;
import cn.com.antcloud.api.bccr.v1_0_0.model.VerifyStatementData;
import cn.com.antcloud.api.bccr.v1_0_0.model.VerifyUserData;
import cn.com.antcloud.api.bccr.v1_0_0.response.VerifyBlockchainResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 链上核验 */
public class VerifyBlockchainRequest extends AntCloudProdRequest<VerifyBlockchainResponse> {
  @NotNull
  private String txHash;

  private String fileHash;

  private String fileId;

  private VerifyUserData userData;

  private VerifyStatementData statementData;

  private VerifyEvidenceData evidenceData;

  public VerifyBlockchainRequest(String productInstanceId) {
    super("blockchain.bccr.blockchain.verify", "1.0", "Java-SDK-20211221", productInstanceId);
  }

  public VerifyBlockchainRequest() {
    super("blockchain.bccr.blockchain.verify", "1.0", null);
    this.setSdkVersion("Java-SDK-20211221");
  }

  /**
   * 统一证据编号（存证交易HASH） */
  public String getTxHash() {
    return this.txHash;
  }

  /**
   * 统一证据编号（存证交易HASH） */
  public void setTxHash(String txHash) {
    this.txHash = txHash;
  }

  /**
   * 文件HASH，使用HEX的完整表示，如 6460c949f8a347eb...
   *
   * (和fileId 二选一，必传一个，都传按fileHash为准) */
  public String getFileHash() {
    return this.fileHash;
  }

  /**
   * 文件HASH，使用HEX的完整表示，如 6460c949f8a347eb...
   *
   * (和fileId 二选一，必传一个，都传按fileHash为准) */
  public void setFileHash(String fileHash) {
    this.fileHash = fileHash;
  }

  /**
   * 文件OSS Id（上传文件有大小限制，文本文件最大100M，图片最大1G，视频和压缩包最大2G）
   *
   * (和fileHash 二选一，必传一个，都传按fileHash为准) */
  public String getFileId() {
    return this.fileId;
  }

  /**
   * 文件OSS Id（上传文件有大小限制，文本文件最大100M，图片最大1G，视频和压缩包最大2G）
   *
   * (和fileHash 二选一，必传一个，都传按fileHash为准) */
  public void setFileId(String fileId) {
    this.fileId = fileId;
  }

  /**
   * 核验用户信息 */
  public VerifyUserData getUserData() {
    return this.userData;
  }

  /**
   * 核验用户信息 */
  public void setUserData(VerifyUserData userData) {
    this.userData = userData;
  }

  /**
   * 核验权利声明信息 */
  public VerifyStatementData getStatementData() {
    return this.statementData;
  }

  /**
   * 核验权利声明信息 */
  public void setStatementData(VerifyStatementData statementData) {
    this.statementData = statementData;
  }

  /**
   * 核验取证信息 */
  public VerifyEvidenceData getEvidenceData() {
    return this.evidenceData;
  }

  /**
   * 核验取证信息 */
  public void setEvidenceData(VerifyEvidenceData evidenceData) {
    this.evidenceData = evidenceData;
  }
}
