//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.request;

import cn.com.antcloud.api.bccr.v1_0_0.response.QueryScreenshotResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 查询网页取证 */
public class QueryScreenshotRequest extends AntCloudProdRequest<QueryScreenshotResponse> {
  @NotNull
  private String evidenceId;

  public QueryScreenshotRequest(String productInstanceId) {
    super("blockchain.bccr.screenshot.query", "1.0", "Java-SDK-20211221", productInstanceId);
  }

  public QueryScreenshotRequest() {
    super("blockchain.bccr.screenshot.query", "1.0", null);
    this.setSdkVersion("Java-SDK-20211221");
  }

  /**
   * 取证id */
  public String getEvidenceId() {
    return this.evidenceId;
  }

  /**
   * 取证id */
  public void setEvidenceId(String evidenceId) {
    this.evidenceId = evidenceId;
  }
}
