//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.request;

import cn.com.antcloud.api.bccr.v1_0_0.response.GetUploadurlResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 调用接口获取版权开放平台授权访问oss链接 */
public class GetUploadurlRequest extends AntCloudProdRequest<GetUploadurlResponse> {
  @NotNull
  private String fileName;

  private String clientToken;

  public GetUploadurlRequest(String productInstanceId) {
    super("blockchain.bccr.uploadurl.get", "1.0", "Java-SDK-20211221", productInstanceId);
  }

  public GetUploadurlRequest() {
    super("blockchain.bccr.uploadurl.get", "1.0", null);
    this.setSdkVersion("Java-SDK-20211221");
  }

  /**
   * 文件名称 */
  public String getFileName() {
    return this.fileName;
  }

  /**
   * 文件名称 */
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  /**
   * 保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。clientToken只支持ASCII字符，且不能超过64个字符。 */
  public String getClientToken() {
    return this.clientToken;
  }

  /**
   * 保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。clientToken只支持ASCII字符，且不能超过64个字符。 */
  public void setClientToken(String clientToken) {
    this.clientToken = clientToken;
  }
}
