//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.request;

import cn.com.antcloud.api.bccr.v1_0_0.model.AccountData;
import cn.com.antcloud.api.bccr.v1_0_0.model.ProxyData;
import cn.com.antcloud.api.bccr.v1_0_0.response.AddRegisterResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Boolean;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 版权平台新增版权登记 */
public class AddRegisterRequest extends AntCloudProdRequest<AddRegisterResponse> {
  @NotNull
  private String fileId;

  private Boolean createCertificate;

  private String certificateType;

  private Boolean createPackage;

  private String orgId;

  @NotNull
  private String name;

  @NotNull
  private String type;

  private String memo;

  @NotNull
  private String certName;

  @NotNull
  private String certNo;

  @NotNull
  private String certType;

  private String phoneNum;

  private String clientToken;

  private ProxyData proxyInfo;

  private AccountData syncInfo;

  public AddRegisterRequest(String productInstanceId) {
    super("blockchain.bccr.register.add", "1.0", "Java-SDK-20211221", productInstanceId);
  }

  public AddRegisterRequest() {
    super("blockchain.bccr.register.add", "1.0", null);
    this.setSdkVersion("Java-SDK-20211221");
  }

  /**
   * 文件oss id */
  public String getFileId() {
    return this.fileId;
  }

  /**
   * 文件oss id */
  public void setFileId(String fileId) {
    this.fileId = fileId;
  }

  /**
   * 是否自动创建公证书,默认否 */
  public Boolean getCreateCertificate() {
    return this.createCertificate;
  }

  /**
   * 是否自动创建公证书,默认否 */
  public void setCreateCertificate(Boolean createCertificate) {
    this.createCertificate = createCertificate;
  }

  /**
   * 证书类型 */
  public String getCertificateType() {
    return this.certificateType;
  }

  /**
   * 证书类型 */
  public void setCertificateType(String certificateType) {
    this.certificateType = certificateType;
  }

  /**
   * 是否创建证据包，默认否 */
  public Boolean getCreatePackage() {
    return this.createPackage;
  }

  /**
   * 是否创建证据包，默认否 */
  public void setCreatePackage(Boolean createPackage) {
    this.createPackage = createPackage;
  }

  /**
   * 公证处id */
  public String getOrgId() {
    return this.orgId;
  }

  /**
   * 公证处id */
  public void setOrgId(String orgId) {
    this.orgId = orgId;
  }

  /**
   * 文件名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 文件名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 文件类型 */
  public String getType() {
    return this.type;
  }

  /**
   * 文件类型 */
  public void setType(String type) {
    this.type = type;
  }

  /**
   * 备注 */
  public String getMemo() {
    return this.memo;
  }

  /**
   * 备注 */
  public void setMemo(String memo) {
    this.memo = memo;
  }

  /**
   * 证件名称 */
  public String getCertName() {
    return this.certName;
  }

  /**
   * 证件名称 */
  public void setCertName(String certName) {
    this.certName = certName;
  }

  /**
   * 证件号码 */
  public String getCertNo() {
    return this.certNo;
  }

  /**
   * 证件号码 */
  public void setCertNo(String certNo) {
    this.certNo = certNo;
  }

  /**
   * 证件类型 */
  public String getCertType() {
    return this.certType;
  }

  /**
   * 证件类型 */
  public void setCertType(String certType) {
    this.certType = certType;
  }

  /**
   * 电话号码 */
  public String getPhoneNum() {
    return this.phoneNum;
  }

  /**
   * 电话号码 */
  public void setPhoneNum(String phoneNum) {
    this.phoneNum = phoneNum;
  }

  /**
   * 幂等 */
  public String getClientToken() {
    return this.clientToken;
  }

  /**
   * 幂等 */
  public void setClientToken(String clientToken) {
    this.clientToken = clientToken;
  }

  /**
   * 代理信息 */
  public ProxyData getProxyInfo() {
    return this.proxyInfo;
  }

  /**
   * 代理信息 */
  public void setProxyInfo(ProxyData proxyInfo) {
    this.proxyInfo = proxyInfo;
  }

  /**
   * 同步账号信息 */
  public AccountData getSyncInfo() {
    return this.syncInfo;
  }

  /**
   * 同步账号信息 */
  public void setSyncInfo(AccountData syncInfo) {
    this.syncInfo = syncInfo;
  }
}
