//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 网页取证具体信息 */
public class ScreenshotInfo {
  private String processLogFile;

  private String checkLogFile;

  @NotNull
  private String screenshotFile;

  private String processLogFileTxHash;

  private String checkLogFileTxHash;

  /**
   * 全链路取证日志文件下载链接 */
  public String getProcessLogFile() {
    return this.processLogFile;
  }

  /**
   * 全链路取证日志文件下载链接 */
  public void setProcessLogFile(String processLogFile) {
    this.processLogFile = processLogFile;
  }

  /**
   * 自清洁文件下载链接 */
  public String getCheckLogFile() {
    return this.checkLogFile;
  }

  /**
   * 自清洁文件下载链接 */
  public void setCheckLogFile(String checkLogFile) {
    this.checkLogFile = checkLogFile;
  }

  /**
   * 网页截图文件下载链接 */
  public String getScreenshotFile() {
    return this.screenshotFile;
  }

  /**
   * 网页截图文件下载链接 */
  public void setScreenshotFile(String screenshotFile) {
    this.screenshotFile = screenshotFile;
  }

  /**
   * 操作日志文件交易hash */
  public String getProcessLogFileTxHash() {
    return this.processLogFileTxHash;
  }

  /**
   * 操作日志文件交易hash */
  public void setProcessLogFileTxHash(String processLogFileTxHash) {
    this.processLogFileTxHash = processLogFileTxHash;
  }

  /**
   * 自清洁日志文件交易hash */
  public String getCheckLogFileTxHash() {
    return this.checkLogFileTxHash;
  }

  /**
   * 自清洁日志文件交易hash */
  public void setCheckLogFileTxHash(String checkLogFileTxHash) {
    this.checkLogFileTxHash = checkLogFileTxHash;
  }
}
