//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 网页取证数据 */
public class ScreenshotData {
  @NotNull
  private String url;

  @NotNull
  private Long gmtEvidence;

  private String fileHash;

  private Long fileSize;

  private String txHash;

  private Long blockHeight;

  private Long timestamp;

  private String tsr;

  private String certificateUrl;

  private String certificateStorageNo;

  private String toolVersion;

  private String screenshotZip;

  private ScreenshotInfo screenshotInfo;

  private String headTitle;

  /**
   * 取证地址 */
  public String getUrl() {
    return this.url;
  }

  /**
   * 取证地址 */
  public void setUrl(String url) {
    this.url = url;
  }

  /**
   * 网页取证时间 */
  public Long getGmtEvidence() {
    return this.gmtEvidence;
  }

  /**
   * 网页取证时间 */
  public void setGmtEvidence(Long gmtEvidence) {
    this.gmtEvidence = gmtEvidence;
  }

  /**
   * 网页取证文件Hash值 */
  public String getFileHash() {
    return this.fileHash;
  }

  /**
   * 网页取证文件Hash值 */
  public void setFileHash(String fileHash) {
    this.fileHash = fileHash;
  }

  /**
   * 网页取证文件大小 */
  public Long getFileSize() {
    return this.fileSize;
  }

  /**
   * 网页取证文件大小 */
  public void setFileSize(Long fileSize) {
    this.fileSize = fileSize;
  }

  /**
   * 统一证据编号 */
  public String getTxHash() {
    return this.txHash;
  }

  /**
   * 统一证据编号 */
  public void setTxHash(String txHash) {
    this.txHash = txHash;
  }

  /**
   * 网页取证文件存证块高 */
  public Long getBlockHeight() {
    return this.blockHeight;
  }

  /**
   * 网页取证文件存证块高 */
  public void setBlockHeight(Long blockHeight) {
    this.blockHeight = blockHeight;
  }

  /**
   * 网页取证文件上链时间 */
  public Long getTimestamp() {
    return this.timestamp;
  }

  /**
   * 网页取证文件上链时间 */
  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }

  /**
   * 可信时间戳的返回对象 */
  public String getTsr() {
    return this.tsr;
  }

  /**
   * 可信时间戳的返回对象 */
  public void setTsr(String tsr) {
    this.tsr = tsr;
  }

  /**
   * 网页截图文件公证处证书下载链接 */
  public String getCertificateUrl() {
    return this.certificateUrl;
  }

  /**
   * 网页截图文件公证处证书下载链接 */
  public void setCertificateUrl(String certificateUrl) {
    this.certificateUrl = certificateUrl;
  }

  /**
   * 公证处证书编号 */
  public String getCertificateStorageNo() {
    return this.certificateStorageNo;
  }

  /**
   * 公证处证书编号 */
  public void setCertificateStorageNo(String certificateStorageNo) {
    this.certificateStorageNo = certificateStorageNo;
  }

  /**
   * 网页取证工具软件版本号 */
  public String getToolVersion() {
    return this.toolVersion;
  }

  /**
   * 网页取证工具软件版本号 */
  public void setToolVersion(String toolVersion) {
    this.toolVersion = toolVersion;
  }

  /**
   * 证据包下载地址（状态为SUCCESS 才有数据） */
  public String getScreenshotZip() {
    return this.screenshotZip;
  }

  /**
   * 证据包下载地址（状态为SUCCESS 才有数据） */
  public void setScreenshotZip(String screenshotZip) {
    this.screenshotZip = screenshotZip;
  }

  /**
   * 取证文件信息 */
  public ScreenshotInfo getScreenshotInfo() {
    return this.screenshotInfo;
  }

  /**
   * 取证文件信息 */
  public void setScreenshotInfo(ScreenshotInfo screenshotInfo) {
    this.screenshotInfo = screenshotInfo;
  }

  /**
   * 网页title */
  public String getHeadTitle() {
    return this.headTitle;
  }

  /**
   * 网页title */
  public void setHeadTitle(String headTitle) {
    this.headTitle = headTitle;
  }
}
