//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.model;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 权利信息 */
public class RightsInfo {
  @NotNull
  private String workName;

  @NotNull
  private String workType;

  @NotNull
  private Long completedTime;

  @NotNull
  private String completedPlace;

  @NotNull
  private Boolean isPublish;

  private Long publishTime;

  private String publishPlace;

  private String publishWeb;

  @NotNull
  private Boolean isAuthor;

  private String authorCertName;

  private String authorCertNo;

  /**
   * 作品名称（最长128个字符） */
  public String getWorkName() {
    return this.workName;
  }

  /**
   * 作品名称（最长128个字符） */
  public void setWorkName(String workName) {
    this.workName = workName;
  }

  /**
   * 作品类型 */
  public String getWorkType() {
    return this.workType;
  }

  /**
   * 作品类型 */
  public void setWorkType(String workType) {
    this.workType = workType;
  }

  /**
   * 作品创作完成时间 */
  public Long getCompletedTime() {
    return this.completedTime;
  }

  /**
   * 作品创作完成时间 */
  public void setCompletedTime(Long completedTime) {
    this.completedTime = completedTime;
  }

  /**
   * 作品创作完成地点（最长128个字符） */
  public String getCompletedPlace() {
    return this.completedPlace;
  }

  /**
   * 作品创作完成地点（最长128个字符） */
  public void setCompletedPlace(String completedPlace) {
    this.completedPlace = completedPlace;
  }

  /**
   * 是否发表 */
  public Boolean getIsPublish() {
    return this.isPublish;
  }

  /**
   * 是否发表 */
  public void setIsPublish(Boolean isPublish) {
    this.isPublish = isPublish;
  }

  /**
   * 发表时间（如果isPublish为true则必填） */
  public Long getPublishTime() {
    return this.publishTime;
  }

  /**
   * 发表时间（如果isPublish为true则必填） */
  public void setPublishTime(Long publishTime) {
    this.publishTime = publishTime;
  }

  /**
   * 发表地点（如果isPublish为true则必填，最长128个字符） */
  public String getPublishPlace() {
    return this.publishPlace;
  }

  /**
   * 发表地点（如果isPublish为true则必填，最长128个字符） */
  public void setPublishPlace(String publishPlace) {
    this.publishPlace = publishPlace;
  }

  /**
   * 发表网址（如果isPublish为true则必填，最长1024个字符） */
  public String getPublishWeb() {
    return this.publishWeb;
  }

  /**
   * 发表网址（如果isPublish为true则必填，最长1024个字符） */
  public void setPublishWeb(String publishWeb) {
    this.publishWeb = publishWeb;
  }

  /**
   * 是否是作者 */
  public Boolean getIsAuthor() {
    return this.isAuthor;
  }

  /**
   * 是否是作者 */
  public void setIsAuthor(Boolean isAuthor) {
    this.isAuthor = isAuthor;
  }

  /**
   * 作者姓名（如果isAuthor为true则必填，最长32个字符） */
  public String getAuthorCertName() {
    return this.authorCertName;
  }

  /**
   * 作者姓名（如果isAuthor为true则必填，最长32个字符） */
  public void setAuthorCertName(String authorCertName) {
    this.authorCertName = authorCertName;
  }

  /**
   * 作者身份证号（如果isAuthor为true则必填） */
  public String getAuthorCertNo() {
    return this.authorCertNo;
  }

  /**
   * 作者身份证号（如果isAuthor为true则必填） */
  public void setAuthorCertNo(String authorCertNo) {
    this.authorCertNo = authorCertNo;
  }
}
