//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 录屏取证信息 */
public class RecordScreenData {
  private String errorReason;

  private String fileHash;

  @NotNull
  private Long gmtEnd;

  @NotNull
  private Long gmtStart;

  @NotNull
  private String osVersion;

  private ScreenInfo screenInfo;

  private String screenZip;

  @NotNull
  private String swVersion;

  private String tsr;

  private String txHash;

  private Long fileSize;

  private Long blockHeight;

  private Long timestamp;

  private String certificateUrl;

  private String certificateStorageNo;

  /**
   * 错误原因（状态为FAIL才有数据） */
  public String getErrorReason() {
    return this.errorReason;
  }

  /**
   * 错误原因（状态为FAIL才有数据） */
  public void setErrorReason(String errorReason) {
    this.errorReason = errorReason;
  }

  /**
   * 录屏文件Hash值 */
  public String getFileHash() {
    return this.fileHash;
  }

  /**
   * 录屏文件Hash值 */
  public void setFileHash(String fileHash) {
    this.fileHash = fileHash;
  }

  /**
   * 录屏结束时间 */
  public Long getGmtEnd() {
    return this.gmtEnd;
  }

  /**
   * 录屏结束时间 */
  public void setGmtEnd(Long gmtEnd) {
    this.gmtEnd = gmtEnd;
  }

  /**
   * 录屏开始时间 */
  public Long getGmtStart() {
    return this.gmtStart;
  }

  /**
   * 录屏开始时间 */
  public void setGmtStart(Long gmtStart) {
    this.gmtStart = gmtStart;
  }

  /**
   * OS版本号 */
  public String getOsVersion() {
    return this.osVersion;
  }

  /**
   * OS版本号 */
  public void setOsVersion(String osVersion) {
    this.osVersion = osVersion;
  }

  /**
   * 录屏文件信息 */
  public ScreenInfo getScreenInfo() {
    return this.screenInfo;
  }

  /**
   * 录屏文件信息 */
  public void setScreenInfo(ScreenInfo screenInfo) {
    this.screenInfo = screenInfo;
  }

  /**
   * 证据包下载地址（状态为SUCCESS 才有数据） */
  public String getScreenZip() {
    return this.screenZip;
  }

  /**
   * 证据包下载地址（状态为SUCCESS 才有数据） */
  public void setScreenZip(String screenZip) {
    this.screenZip = screenZip;
  }

  /**
   * 录屏软件版本号 */
  public String getSwVersion() {
    return this.swVersion;
  }

  /**
   * 录屏软件版本号 */
  public void setSwVersion(String swVersion) {
    this.swVersion = swVersion;
  }

  /**
   * 可信时间戳的返回对象 */
  public String getTsr() {
    return this.tsr;
  }

  /**
   * 可信时间戳的返回对象 */
  public void setTsr(String tsr) {
    this.tsr = tsr;
  }

  /**
   * 统一证据编号 */
  public String getTxHash() {
    return this.txHash;
  }

  /**
   * 统一证据编号 */
  public void setTxHash(String txHash) {
    this.txHash = txHash;
  }

  /**
   * 录屏文件大小 */
  public Long getFileSize() {
    return this.fileSize;
  }

  /**
   * 录屏文件大小 */
  public void setFileSize(Long fileSize) {
    this.fileSize = fileSize;
  }

  /**
   * 录屏文件存证块高 */
  public Long getBlockHeight() {
    return this.blockHeight;
  }

  /**
   * 录屏文件存证块高 */
  public void setBlockHeight(Long blockHeight) {
    this.blockHeight = blockHeight;
  }

  /**
   * 录屏文件上链时间 */
  public Long getTimestamp() {
    return this.timestamp;
  }

  /**
   * 录屏文件上链时间 */
  public void setTimestamp(Long timestamp) {
    this.timestamp = timestamp;
  }

  /**
   * 录屏文件公证处证书下载链接 */
  public String getCertificateUrl() {
    return this.certificateUrl;
  }

  /**
   * 录屏文件公证处证书下载链接 */
  public void setCertificateUrl(String certificateUrl) {
    this.certificateUrl = certificateUrl;
  }

  /**
   * 公证处证书编号 */
  public String getCertificateStorageNo() {
    return this.certificateStorageNo;
  }

  /**
   * 公证处证书编号 */
  public void setCertificateStorageNo(String certificateStorageNo) {
    this.certificateStorageNo = certificateStorageNo;
  }
}
