//
//  Copyright (c) 2020-present antgroup.com, https://www.antgroup.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.bccr.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 监测任务结果 */
public class MonitorResult {
  @NotNull
  private String monitorTaskId;

  @NotNull
  private String monitorResultId;

  private String infrUrl;

  private String infrHost;

  private String infrTitle;

  private Long infrTime;

  private String detail;

  private String poster;

  private Long postDate;

  private Long findDate;

  private Long viewCount;

  private Long likeCount;

  private Long commentCount;

  private Long repostCount;

  private String downloadUrl;

  private Long infrFeedbackTime;

  /**
   * 监测任务ID
   */
  public String getMonitorTaskId() {
    return this.monitorTaskId;
  }

  /**
   * 监测任务ID
   */
  public void setMonitorTaskId(String monitorTaskId) {
    this.monitorTaskId = monitorTaskId;
  }

  /**
   * 监测结果ID
   */
  public String getMonitorResultId() {
    return this.monitorResultId;
  }

  /**
   * 监测结果ID
   */
  public void setMonitorResultId(String monitorResultId) {
    this.monitorResultId = monitorResultId;
  }

  /**
   * 侵权网址
   *
   */
  public String getInfrUrl() {
    return this.infrUrl;
  }

  /**
   * 侵权网址
   *
   */
  public void setInfrUrl(String infrUrl) {
    this.infrUrl = infrUrl;
  }

  /**
   * 侵权主体
   *
   */
  public String getInfrHost() {
    return this.infrHost;
  }

  /**
   * 侵权主体
   *
   */
  public void setInfrHost(String infrHost) {
    this.infrHost = infrHost;
  }

  /**
   * 侵权标题
   *
   */
  public String getInfrTitle() {
    return this.infrTitle;
  }

  /**
   * 侵权标题
   *
   */
  public void setInfrTitle(String infrTitle) {
    this.infrTitle = infrTitle;
  }

  /**
   * 侵权内容上传时间
   *
   */
  public Long getInfrTime() {
    return this.infrTime;
  }

  /**
   * 侵权内容上传时间
   *
   */
  public void setInfrTime(Long infrTime) {
    this.infrTime = infrTime;
  }

  /**
   * 侵权详情
   */
  public String getDetail() {
    return this.detail;
  }

  /**
   * 侵权详情
   */
  public void setDetail(String detail) {
    this.detail = detail;
  }

  /**
   * 发布者 */
  public String getPoster() {
    return this.poster;
  }

  /**
   * 发布者 */
  public void setPoster(String poster) {
    this.poster = poster;
  }

  /**
   * 侵权内容发布时间 */
  public Long getPostDate() {
    return this.postDate;
  }

  /**
   * 侵权内容发布时间 */
  public void setPostDate(Long postDate) {
    this.postDate = postDate;
  }

  /**
   * 侵权内容发现时间 */
  public Long getFindDate() {
    return this.findDate;
  }

  /**
   * 侵权内容发现时间 */
  public void setFindDate(Long findDate) {
    this.findDate = findDate;
  }

  /**
   * 观看数 */
  public Long getViewCount() {
    return this.viewCount;
  }

  /**
   * 观看数 */
  public void setViewCount(Long viewCount) {
    this.viewCount = viewCount;
  }

  /**
   * 点赞数 */
  public Long getLikeCount() {
    return this.likeCount;
  }

  /**
   * 点赞数 */
  public void setLikeCount(Long likeCount) {
    this.likeCount = likeCount;
  }

  /**
   * 评论数 */
  public Long getCommentCount() {
    return this.commentCount;
  }

  /**
   * 评论数 */
  public void setCommentCount(Long commentCount) {
    this.commentCount = commentCount;
  }

  /**
   * 转发数 */
  public Long getRepostCount() {
    return this.repostCount;
  }

  /**
   * 转发数 */
  public void setRepostCount(Long repostCount) {
    this.repostCount = repostCount;
  }

  /**
   * 侵权文件下载链接 */
  public String getDownloadUrl() {
    return this.downloadUrl;
  }

  /**
   * 侵权文件下载链接 */
  public void setDownloadUrl(String downloadUrl) {
    this.downloadUrl = downloadUrl;
  }

  /**
   * 疑似侵权反馈时间 */
  public Long getInfrFeedbackTime() {
    return this.infrFeedbackTime;
  }

  /**
   * 疑似侵权反馈时间 */
  public void setInfrFeedbackTime(Long infrFeedbackTime) {
    this.infrFeedbackTime = infrFeedbackTime;
  }
}
