/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SearchHit<T> {
    private final String id;
    private final float score;
    private final List<Object> sortValues;
    private final T content;
    private final Map<String, List<String>> highlightFields = new LinkedHashMap<String, List<String>>();

    public SearchHit(@Nullable String id, float score, @Nullable Object[] sortValues, @Nullable Map<String, List<String>> highlightFields, T content) {
        this.id = id;
        this.score = score;
        List<Object> list = this.sortValues = sortValues != null ? Arrays.asList(sortValues) : new ArrayList<Object>();
        if (highlightFields != null) {
            this.highlightFields.putAll(highlightFields);
        }
        this.content = content;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public float getScore() {
        return this.score;
    }

    public T getContent() {
        return this.content;
    }

    public List<Object> getSortValues() {
        return Collections.unmodifiableList(this.sortValues);
    }

    public Map<String, List<String>> getHighlightFields() {
        return Collections.unmodifiableMap(this.highlightFields.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableList((List)entry.getValue()))));
    }

    public List<String> getHighlightField(String field) {
        Assert.notNull((Object)field, (String)"field must not be null");
        return Collections.unmodifiableList(this.highlightFields.getOrDefault(field, Collections.emptyList()));
    }

    public String toString() {
        return "SearchHit{id='" + this.id + '\'' + ", score=" + this.score + ", sortValues=" + this.sortValues + ", content=" + this.content + ", highlightFields=" + this.highlightFields + '}';
    }
}

