/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.stax2.XMLInputFactory2;

public abstract class AbstractVersionsUpdaterMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    protected final RepositorySystem repositorySystem;
    protected org.eclipse.aether.RepositorySystem aetherRepositorySystem;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(property="maven.version.rules.serverId", defaultValue="serverId")
    private String serverId;
    @Parameter(property="maven.version.rules")
    private String rulesUri;
    @Parameter(property="generateBackupPoms", defaultValue="true")
    protected boolean generateBackupPoms;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;
    private VersionsHelper helper;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Parameter(property="changeRecorderFormat", defaultValue="none")
    private String changeRecorderFormat = "none";
    @Parameter(property="changeRecorderOutputFile", defaultValue="${project.build.directory}/versions-changes.xml")
    private File changeRecorderOutputFile;
    private Map<String, ChangeRecorder> changeRecorders;
    @Parameter
    protected RuleSet ruleSet;
    @Parameter(property="maven.version.ignore")
    protected Set<String> ignoredVersions;
    protected final Map<String, Wagon> wagonMap;

    @Inject
    protected AbstractVersionsUpdaterMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        this.repositorySystem = repositorySystem;
        this.aetherRepositorySystem = aetherRepositorySystem;
        this.wagonMap = wagonMap;
        this.changeRecorders = changeRecorders;
    }

    public VersionsHelper getHelper() throws MojoExecutionException {
        if (this.helper == null) {
            this.helper = new DefaultVersionsHelper.Builder().withRepositorySystem(this.repositorySystem).withAetherRepositorySystem(this.aetherRepositorySystem).withWagonMap(this.wagonMap).withServerId(this.serverId).withRulesUri(this.rulesUri).withRuleSet(this.ruleSet).withIgnoredVersions(this.ignoredVersions).withLog(this.getLog()).withMavenSession(this.session).withMojoExecution(this.mojoExecution).build();
        }
        return this.helper;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getVersion() {
        return this.getProject() == null ? null : this.getProject().getVersion();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateInput();
        File outFile = this.project.getFile();
        this.process(outFile);
    }

    protected void validateInput() throws MojoExecutionException {
    }

    protected ArtifactVersion findLatestVersion(Artifact artifact, VersionRange versionRange, Boolean allowingSnapshots, boolean usePluginRepositories) throws MojoExecutionException, VersionRetrievalException {
        boolean includeSnapshots = allowingSnapshots != null ? allowingSnapshots : this.allowSnapshots;
        ArtifactVersions artifactVersions = this.getHelper().lookupArtifactVersions(artifact, versionRange, usePluginRepositories);
        return artifactVersions.getNewestVersion(versionRange, null, includeSnapshots, false);
    }

    protected void process(File outFile) throws MojoExecutionException, MojoFailureException {
        try {
            StringBuilder input = PomHelper.readXmlFile((File)outFile);
            ModifiedPomXMLEventReader newPom = this.newModifiedPomXER(input, outFile.getAbsolutePath());
            this.update(newPom);
            if (newPom.isModified()) {
                if (this.generateBackupPoms) {
                    File backupFile = new File(outFile.getParentFile(), outFile.getName() + ".versionsBackup");
                    if (!backupFile.exists()) {
                        this.getLog().debug((CharSequence)("Backing up " + outFile + " to " + backupFile));
                        FileUtils.copyFile((File)outFile, (File)backupFile);
                    } else {
                        this.getLog().debug((CharSequence)("Leaving existing backup " + backupFile + " unmodified"));
                    }
                } else {
                    this.getLog().debug((CharSequence)"Skipping generation of backup file");
                }
                this.writeFile(outFile, input);
            }
            this.saveChangeRecorderResults();
        }
        catch (IOException | XMLStreamException e) {
            this.getLog().error((Throwable)e);
        }
        catch (VersionRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected final ModifiedPomXMLEventReader newModifiedPomXER(StringBuilder input, String path) {
        ModifiedPomXMLEventReader newPom = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory2.newInstance();
            inputFactory.setProperty("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
            newPom = new ModifiedPomXMLEventReader(input, inputFactory, path);
        }
        catch (XMLStreamException e) {
            this.getLog().error((Throwable)e);
        }
        return newPom;
    }

    protected final void writeFile(File outFile, StringBuilder input) throws IOException {
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)outFile);){
            IOUtil.copy((String)input.toString(), (Writer)writer);
        }
    }

    protected abstract void update(ModifiedPomXMLEventReader var1) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException;

    @Deprecated
    protected boolean shouldApplyUpdate(Artifact artifact, String currentVersion, ArtifactVersion updateVersion) {
        return this.shouldApplyUpdate(artifact, currentVersion, updateVersion, false);
    }

    protected boolean shouldApplyUpdate(Artifact artifact, String currentVersion, ArtifactVersion updateVersion, boolean forceUpdate) {
        this.getLog().debug((CharSequence)("Proposal is to update from " + currentVersion + " to " + updateVersion));
        if (updateVersion == null) {
            this.getLog().warn((CharSequence)"Not updating version: could not resolve any versions");
            return false;
        }
        if (forceUpdate) {
            this.getLog().info((CharSequence)"Force update enabled. LATEST or RELEASE versions will be overwritten with real version");
            return true;
        }
        artifact.setVersion(updateVersion.toString());
        try {
            this.getHelper().resolveArtifact(artifact, false);
        }
        catch (ArtifactResolutionException | MojoExecutionException e) {
            this.getLog().warn((CharSequence)("Not updating version: could not resolve " + artifact), e);
            return false;
        }
        if (currentVersion.equals(updateVersion.toString())) {
            this.getLog().info((CharSequence)("Current version of " + artifact + " is the latest."));
            return false;
        }
        return true;
    }

    protected ArtifactVersion updatePropertyToNewestVersion(ModifiedPomXMLEventReader pom, Property property, PropertyVersions version, String currentVersion, boolean allowDowngrade, Optional<Segment> unchangedSegment) throws XMLStreamException, InvalidVersionSpecificationException, InvalidSegmentException, MojoExecutionException {
        ArtifactVersion winner = version.getNewestVersion(currentVersion, property, this.allowSnapshots, this.reactorProjects, this.getHelper(), allowDowngrade, unchangedSegment);
        if (winner == null || currentVersion.equals(winner.toString())) {
            this.getLog().info((CharSequence)("Property ${" + property.getName() + "}: Leaving unchanged as " + currentVersion));
        } else if (PomHelper.setPropertyVersion((ModifiedPomXMLEventReader)pom, (String)version.getProfileId(), (String)property.getName(), (String)winner.toString())) {
            this.getLog().info((CharSequence)("Updated ${" + property.getName() + "} from " + currentVersion + " to " + winner));
            return winner;
        }
        return null;
    }

    protected ChangeRecorder getChangeRecorder() throws MojoExecutionException {
        ChangeRecorder changeRecorder = this.changeRecorders.get(this.changeRecorderFormat);
        if (changeRecorder == null) {
            throw new MojoExecutionException("Only " + this.changeRecorders.keySet() + " formats are supported for change recordings");
        }
        return changeRecorder;
    }

    protected void saveChangeRecorderResults() throws IOException, MojoExecutionException {
        this.getLog().debug((CharSequence)("writing change record to " + this.changeRecorderOutputFile));
        this.getChangeRecorder().writeReport((Path)Optional.ofNullable(this.changeRecorderOutputFile).map(File::toPath).orElse(null));
    }
}

