/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.yeepay.yop.sdk.exception.YopClientException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class JacksonJsonMarshaller {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JacksonJsonMarshaller() {
    }

    public static <T> T unmarshal(String content, Class<T> objectType) {
        try {
            return (T)objectMapper.readValue(content, objectType);
        }
        catch (IOException e) {
            throw new YopClientException(e.getMessage(), (Throwable)e);
        }
    }

    public static <T> T unmarshal(InputStream content, Class<T> objectType) {
        try {
            return (T)objectMapper.readValue(content, objectType);
        }
        catch (IOException e) {
            throw new YopClientException(e.getMessage(), (Throwable)e);
        }
    }

    public static void load(String content, Object obj) {
        try {
            objectMapper.readerForUpdating(obj).readValue(content);
        }
        catch (IOException ex) {
            throw new YopClientException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static String marshal(Object content) {
        try {
            return objectMapper.writeValueAsString(content);
        }
        catch (JsonProcessingException e) {
            throw new YopClientException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
    }
}

