/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.analyzer;

import com.google.common.base.CharMatcher;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzer;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.YopResponseMetadata;
import com.yeepay.yop.sdk.utils.X509CertUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopMetadataResponseAnalyzer
implements HttpResponseAnalyzer {
    private static final YopMetadataResponseAnalyzer INSTANCE = new YopMetadataResponseAnalyzer();
    private static final Logger LOGGER = LoggerFactory.getLogger(YopMetadataResponseAnalyzer.class);

    public static YopMetadataResponseAnalyzer getInstance() {
        return INSTANCE;
    }

    private YopMetadataResponseAnalyzer() {
    }

    @Override
    public <T extends BaseResponse> boolean analysis(HttpResponseHandleContext context, T response) throws Exception {
        YopHttpResponse httpResponse = context.getResponse();
        YopResponseMetadata metadata = response.getMetadata();
        metadata.setYopRequestId(httpResponse.getHeader("x-yop-request-id"));
        metadata.setYopContentSha256(httpResponse.getHeader("x-yop-content-sha256"));
        metadata.setYopSign(httpResponse.getHeader("x-yop-sign"));
        metadata.setYopVia(httpResponse.getHeader("x-yop-via"));
        metadata.setContentDisposition(httpResponse.getHeader("Content-Disposition"));
        metadata.setContentEncoding(httpResponse.getHeader("Content-Encoding"));
        metadata.setContentLength(httpResponse.getHeaderAsLong("Content-Length"));
        metadata.setContentMd5(httpResponse.getHeader("Content-MD5"));
        metadata.setContentRange(httpResponse.getHeader("Content-Range"));
        metadata.setContentType(httpResponse.getHeader("Content-Type"));
        metadata.setDate(httpResponse.getHeaderAsRfc822Date("Date"));
        metadata.setTransferEncoding(httpResponse.getHeader("Transfer-Encoding"));
        String eTag = httpResponse.getHeader("ETag");
        if (eTag != null) {
            metadata.setETag(CharMatcher.is((char)'\"').trimFrom((CharSequence)eTag));
        }
        metadata.setExpires(httpResponse.getHeaderAsRfc822Date("Expires"));
        metadata.setLastModified(httpResponse.getHeaderAsRfc822Date("Last-Modified"));
        metadata.setServer(httpResponse.getHeader("Server"));
        String certSerialNo = httpResponse.getHeader("x-yop-sign-serial-no");
        metadata.setYopCertSerialNo(X509CertUtils.parseToHex((String)StringUtils.defaultIfBlank((CharSequence)certSerialNo, (CharSequence)httpResponse.getHeader("x-yop-serial-no"))));
        metadata.setYopEncrypt(httpResponse.getHeader("x-yop-encrypt"));
        this.handleYopResponseMetadata(metadata);
        return false;
    }

    private void handleYopResponseMetadata(YopResponseMetadata metadata) {
        if (StringUtils.equals((CharSequence)metadata.getYopVia(), (CharSequence)"sandbox")) {
            LOGGER.info("response from sandbox-gateway");
        }
    }
}

