/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.cert.parser;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.base.security.cert.parser.YopCertParser;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.cert.YopCertCategory;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;

public class YopCertParserFactory {
    private static final Map<String, YopCertParser> YOP_CERT_PARSER_MAP = Maps.newHashMap();

    public static void registerParser(String parserId, YopCertParser certParser) {
        YOP_CERT_PARSER_MAP.put(parserId, certParser);
    }

    public static YopCertParser getCertParser(String parserId) {
        YopCertParser yopCertParser = YOP_CERT_PARSER_MAP.get(parserId);
        if (null == yopCertParser) {
            throw new YopClientException("YopCertParser not found, parserId:" + parserId);
        }
        return yopCertParser;
    }

    public static String getParserId(YopCertCategory certCategory, CertTypeEnum certType) {
        return StringUtils.joinWith((String)",", (Object[])new Object[]{certCategory, certType});
    }

    public static YopCertParser getCertParser(YopCertCategory certCategory, CertTypeEnum certType) {
        return YopCertParserFactory.getCertParser(YopCertParserFactory.getParserId(certCategory, certType));
    }

    static {
        ServiceLoader<YopCertParser> serviceLoader = ServiceLoader.load(YopCertParser.class);
        for (YopCertParser certParser : serviceLoader) {
            YOP_CERT_PARSER_MAP.put(certParser.parserId(), certParser);
        }
    }
}

