/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.yeepay.yop.sdk.base.security.encrypt.Sm2Enhancer;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptOptionsCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptOptionsCache.class);
    private static final LoadingCache<String, Future<EncryptOptions>> ENCRYPT_OPTIONS_CACHE = EncryptOptionsCache.initCache(24L, TimeUnit.HOURS);

    public static Future<EncryptOptions> loadEncryptOptions(String appKey, String encryptAlg) {
        try {
            return (Future)ENCRYPT_OPTIONS_CACHE.get((Object)EncryptOptionsCache.getCacheKey(appKey, encryptAlg));
        }
        catch (ExecutionException e) {
            throw new YopClientException("initEncryptOptions error, ex:", (Throwable)e);
        }
    }

    public static void refreshEncryptOptions(String appKey, String encryptAlg) {
        try {
            ENCRYPT_OPTIONS_CACHE.refresh((Object)EncryptOptionsCache.getCacheKey(appKey, encryptAlg));
        }
        catch (Exception e) {
            throw new YopClientException("refreshEncryptOptions error, ex:", (Throwable)e);
        }
    }

    public static void invalidateEncryptOptions(String appKey, String encryptAlg) {
        try {
            ENCRYPT_OPTIONS_CACHE.invalidate((Object)EncryptOptionsCache.getCacheKey(appKey, encryptAlg));
        }
        catch (Exception e) {
            throw new YopClientException("invalidateEncryptOptions error, ex:", (Throwable)e);
        }
    }

    public static Future<EncryptOptions> reloadEncryptOptions(String appKey, String encryptAlg) {
        try {
            ENCRYPT_OPTIONS_CACHE.invalidate((Object)EncryptOptionsCache.getCacheKey(appKey, encryptAlg));
        }
        catch (Exception e) {
            throw new YopClientException("invalidate EncryptOptions error, ex:", (Throwable)e);
        }
        return EncryptOptionsCache.loadEncryptOptions(appKey, encryptAlg);
    }

    private static String getCacheKey(String appKey, String encryptAlg) {
        return StringUtils.joinWith((String)",", (Object[])new Object[]{appKey, encryptAlg});
    }

    private static LoadingCache<String, Future<EncryptOptions>> initCache(Long expire, TimeUnit timeUnit) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (expire > 0L) {
            cacheBuilder.expireAfterWrite(expire.longValue(), timeUnit);
        }
        return cacheBuilder.build((CacheLoader)new CacheLoader<String, Future<EncryptOptions>>(){

            public Future<EncryptOptions> load(String cacheKey) throws Exception {
                LOGGER.debug("try to init encryptOptions for cacheKey:" + cacheKey);
                Future encryptOptions = null;
                try {
                    String[] split = cacheKey.split(",");
                    String appKey = split[0];
                    String encryptAlg = split[1];
                    YopEncryptor encryptor = YopEncryptorFactory.getEncryptor(encryptAlg);
                    List<Sm2Enhancer> enhancers = Collections.singletonList(new Sm2Enhancer(appKey));
                    encryptOptions = encryptor.initOptions(encryptAlg, enhancers);
                }
                catch (Exception ex) {
                    LOGGER.warn("UnexpectedException occurred when init encryptOptions for cacheKey:" + cacheKey, (Throwable)ex);
                }
                return encryptOptions;
            }
        });
    }
}

