/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.credentials.provider;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentialsHolder;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProvider;
import com.yeepay.yop.sdk.base.cache.YopCertificateCache;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.utils.X509CertUtils;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YopBasePlatformCredentialsProvider
implements YopPlatformCredentialsProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(YopBasePlatformCredentialsProvider.class);
    protected Map<String, YopPlatformCredentials> credentialsMap = Maps.newConcurrentMap();

    public YopPlatformCredentials getCredentials(String appKey, String serialNo) {
        String realSerialNo;
        if (StringUtils.isBlank((CharSequence)serialNo)) {
            throw new YopClientException("serialNo is required");
        }
        YopPlatformCredentials foundCredentials = this.credentialsMap.computeIfAbsent(serialNo, p -> {
            if (serialNo.equals("rsa")) {
                X509Certificate rsaCert = this.loadLocalRsaCert(appKey, serialNo);
                if (null == rsaCert) {
                    throw new YopClientException("loadLocalRsaCert fail, serialNo:" + serialNo);
                }
                return this.convertRsaCredentials(appKey, CertTypeEnum.RSA2048, rsaCert);
            }
            YopPlatformCredentials localCredentials = this.loadCredentialsFromStore(appKey, serialNo);
            if (null == localCredentials) {
                X509Certificate remoteCert = this.loadRemoteSm2Cert(appKey, serialNo);
                if (null == remoteCert) {
                    throw new YopClientException("loadRemoteSm2Cert fail, serialNo:" + serialNo);
                }
                return this.storeCredentials(appKey, CertTypeEnum.SM2.name(), remoteCert);
            }
            return localCredentials;
        });
        if (null != foundCredentials && !StringUtils.equals((CharSequence)(realSerialNo = foundCredentials.getSerialNo()), (CharSequence)serialNo)) {
            this.credentialsMap.put(realSerialNo, foundCredentials);
        }
        return foundCredentials;
    }

    private YopPlatformCredentials convertRsaCredentials(String appKey, CertTypeEnum certType, X509Certificate cert) {
        return new YopPlatformCredentialsHolder().withAppKey(appKey).withSerialNo(X509CertUtils.parseToHex(cert.getSerialNumber().toString())).withCredentials((CredentialsItem)new PKICredentialsItem(cert.getPublicKey(), certType));
    }

    protected abstract YopPlatformCredentials loadCredentialsFromStore(String var1, String var2);

    protected X509Certificate loadRemoteSm2Cert(String appKey, String serialNo) {
        List<X509Certificate> x509Certificates = YopCertificateCache.loadPlatformSm2Certs(appKey, serialNo);
        if (CollectionUtils.isNotEmpty(x509Certificates)) {
            return x509Certificates.get(0);
        }
        return null;
    }

    protected X509Certificate loadLocalRsaCert(String appKey, String serialNo) {
        return YopCertificateCache.getYopPlatformRsaCertFromLocal();
    }

    public YopPlatformCredentials getLatestCredentials(String appKey, String credentialType) {
        try {
            switch (CertTypeEnum.parse((String)credentialType)) {
                case SM2: {
                    X509Certificate latestCert;
                    try {
                        latestCert = YopCertificateCache.loadPlatformSm2Certs(appKey, "").get(0);
                        if (X509CertUtils.checkCertDate(latestCert)) {
                            latestCert = YopCertificateCache.refreshPlatformSm2Certs(appKey, "").get(0);
                        }
                    }
                    catch (CertificateException e) {
                        LOGGER.warn("YopPlatformCredentials expired and need reload, appKey:" + appKey + ", credentialType:" + credentialType + ", ex", (Throwable)e);
                        latestCert = YopCertificateCache.reloadPlatformSm2Certs(appKey, "").get(0);
                    }
                    YopPlatformCredentials credentials = this.storeCredentials(appKey, CertTypeEnum.SM2.name(), latestCert);
                    this.credentialsMap.put(credentials.getSerialNo(), credentials);
                    return credentials;
                }
                case RSA2048: {
                    return this.getCredentials(appKey, "rsa");
                }
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("no YopPlatformCredentials found for appKey:{}, credentialType:{}", (Object)appKey, (Object)credentialType);
            return null;
        }
    }
}

