/*
 * Decompiled with CFR 0.152.
 */
package com.blockchain.scanning.chain.impl;

import com.blockchain.scanning.biz.thread.EventQueue;
import com.blockchain.scanning.biz.thread.RetryStrategyQueue;
import com.blockchain.scanning.biz.thread.model.EventModel;
import com.blockchain.scanning.chain.ChainScanner;
import com.blockchain.scanning.chain.model.TransactionModel;
import com.blockchain.scanning.chain.model.eth.EthTransactionModel;
import com.blockchain.scanning.commons.codec.EthAbiCodec;
import com.blockchain.scanning.commons.config.BlockChainConfig;
import com.blockchain.scanning.commons.enums.BlockEnums;
import com.blockchain.scanning.commons.util.StringUtil;
import com.blockchain.scanning.monitor.EthMonitorEvent;
import com.blockchain.scanning.monitor.filter.EthMonitorFilter;
import com.blockchain.scanning.monitor.filter.InputDataFilter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.datatypes.Type;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.http.HttpService;

public class ETHChainScanner
extends ChainScanner {
    private Logger logger = LoggerFactory.getLogger(ETHChainScanner.class);
    private List<Web3j> web3jList;
    private List<EthMonitorEvent> ethMonitorEventList;

    @Override
    public void init(BlockChainConfig blockChainConfig, EventQueue eventQueue, RetryStrategyQueue retryStrategyQueue) {
        super.init(blockChainConfig, eventQueue, retryStrategyQueue);
        this.ethMonitorEventList = blockChainConfig.getEventConfig().getEthMonitorEvent();
        this.web3jList = new ArrayList<Web3j>();
        for (HttpService httpService : blockChainConfig.getHttpService()) {
            this.web3jList.add(Web3j.build((Web3jService)httpService));
        }
    }

    @Override
    public void scan(BigInteger beginBlockNumber) {
        try {
            Web3j web3j = this.web3jList.get(this.getNextIndex(this.web3jList.size()));
            BigInteger lastBlockNumber = ((EthBlockNumber)web3j.ethBlockNumber().send()).getBlockNumber();
            if (beginBlockNumber.compareTo(BlockEnums.LAST_BLOCK_NUMBER.getValue()) == 0) {
                beginBlockNumber = lastBlockNumber;
            }
            if (beginBlockNumber.compareTo(lastBlockNumber) > 0) {
                this.logger.info("[ETH], The block height on the chain has fallen behind the block scanning progress, pause scanning in progress ...... , scan progress [{}], latest block height on chain:[{}]", (Object)beginBlockNumber, (Object)lastBlockNumber);
                return;
            }
            EthBlock block = (EthBlock)web3j.ethGetBlockByNumber(DefaultBlockParameter.valueOf((BigInteger)beginBlockNumber), true).send();
            if (block == null || block.getBlock() == null) {
                this.logger.info("[ETH], Block height [{}] does not exist", (Object)beginBlockNumber);
                if (lastBlockNumber.compareTo(beginBlockNumber) > 0) {
                    this.blockChainConfig.setBeginBlockNumber(beginBlockNumber.add(BigInteger.ONE));
                    this.addRetry(beginBlockNumber);
                }
                return;
            }
            List transactionResultList = block.getBlock().getTransactions();
            if (transactionResultList == null || transactionResultList.size() < 1) {
                this.logger.info("[ETH], No transactions were scanned on block height [{}]", (Object)beginBlockNumber);
                if (lastBlockNumber.compareTo(beginBlockNumber) > 0) {
                    this.blockChainConfig.setBeginBlockNumber(beginBlockNumber.add(BigInteger.ONE));
                    this.addRetry(beginBlockNumber);
                }
                return;
            }
            ArrayList<TransactionModel> transactionList = new ArrayList<TransactionModel>();
            for (EthBlock.TransactionResult transactionResult : transactionResultList) {
                EthBlock.TransactionObject transactionObject = (EthBlock.TransactionObject)transactionResult.get();
                transactionList.add(TransactionModel.builder().setEthTransactionModel(EthTransactionModel.builder().setEthBlock(block).setTransactionObject(transactionObject)));
            }
            this.eventQueue.add(EventModel.builder().setCurrentBlockHeight(beginBlockNumber).setTransactionModels(transactionList));
            this.blockChainConfig.setBeginBlockNumber(beginBlockNumber.add(BigInteger.ONE));
        }
        catch (Exception e) {
            this.logger.error("[ETH], An exception occurred while scanning, block height:[{}]", (Object)beginBlockNumber, (Object)e);
        }
    }

    @Override
    public void call(TransactionModel transactionModel) {
        EthBlock.TransactionObject transactionObject = transactionModel.getEthTransactionModel().getTransactionObject();
        for (EthMonitorEvent ethMonitorEvent : this.ethMonitorEventList) {
            try {
                EthMonitorFilter ethMonitorFilter;
                if (transactionObject.getValue() == null) {
                    transactionObject.setValue("0");
                }
                if (transactionObject.getInput() != null && !transactionObject.getInput().toLowerCase().startsWith("0x")) {
                    transactionObject.setInput("0x" + transactionObject.getInput());
                }
                if ((ethMonitorFilter = ethMonitorEvent.ethMonitorFilter()) == null) {
                    ethMonitorEvent.call(transactionModel);
                    continue;
                }
                if (StringUtil.isNotEmpty(ethMonitorFilter.getFromAddress()) && (StringUtil.isEmpty(transactionObject.getFrom()) || !ethMonitorFilter.getFromAddress().equals(transactionObject.getFrom().toLowerCase())) || StringUtil.isNotEmpty(ethMonitorFilter.getToAddress()) && (StringUtil.isEmpty(transactionObject.getTo()) || !ethMonitorFilter.getToAddress().equals(transactionObject.getTo().toLowerCase())) || ethMonitorFilter.getMinValue() != null && ethMonitorFilter.getMinValue().compareTo(transactionObject.getValue()) > 0 || ethMonitorFilter.getMaxValue() != null && ethMonitorFilter.getMaxValue().compareTo(transactionObject.getValue()) < 0 || !this.inputDataFilter(transactionObject, ethMonitorFilter)) continue;
                ethMonitorEvent.call(transactionModel);
            }
            catch (Exception e) {
                this.logger.error("[ETH], An exception occurred in the call method of the listener", (Throwable)e);
            }
        }
    }

    private boolean inputDataFilter(EthBlock.TransactionObject transactionObject, EthMonitorFilter ethMonitorFilter) {
        if (ethMonitorFilter.getInputDataFilter() == null) {
            return true;
        }
        if (StringUtil.isEmpty(transactionObject.getInput()) || transactionObject.getInput().length() < 10) {
            return false;
        }
        InputDataFilter inputDataFilter = ethMonitorFilter.getInputDataFilter();
        if (StringUtil.isEmpty(inputDataFilter.getFunctionCode())) {
            return false;
        }
        if (!transactionObject.getInput().toLowerCase().startsWith(inputDataFilter.getFunctionCode())) {
            return false;
        }
        String inputData = "0x" + transactionObject.getInput().substring(10);
        if (inputDataFilter.getTypeReferences() != null && inputDataFilter.getTypeReferences().length >= 0 && inputDataFilter.getValue() != null && inputDataFilter.getValue().length > 0) {
            if (inputDataFilter.getTypeReferences().length < inputDataFilter.getValue().length) {
                return false;
            }
            List<Type> result = EthAbiCodec.decoderInputData(inputData, inputDataFilter.getTypeReferences());
            if (result == null || result.size() < inputDataFilter.getValue().length) {
                return false;
            }
            for (int i = 0; i < inputDataFilter.getValue().length; ++i) {
                String value = inputDataFilter.getValue()[i];
                Type paramValue = result.get(i);
                if (paramValue == null || paramValue.getValue() == null) {
                    return false;
                }
                if (value == null || value.equals(paramValue.getValue().toString().toLowerCase())) continue;
                return false;
            }
        }
        return true;
    }
}

